/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared.animation;

import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import net.mgsx.gltf.data.animation.GLTFAnimation;
import net.mgsx.gltf.data.animation.GLTFAnimationChannel;
import net.mgsx.gltf.data.animation.GLTFAnimationSampler;
import net.mgsx.gltf.data.data.GLTFAccessor;
import net.mgsx.gltf.loaders.shared.GLTFTypes;
import net.mgsx.gltf.loaders.shared.animation.Interpolation;
import net.mgsx.gltf.loaders.shared.data.DataResolver;
import net.mgsx.gltf.loaders.shared.scene.NodeResolver;
import net.mgsx.gltf.scene3d.animation.NodeAnimationHack;
import net.mgsx.gltf.scene3d.model.CubicQuaternion;
import net.mgsx.gltf.scene3d.model.CubicVector3;
import net.mgsx.gltf.scene3d.model.CubicWeightVector;
import net.mgsx.gltf.scene3d.model.NodePlus;
import net.mgsx.gltf.scene3d.model.WeightVector;

public class AnimationLoader {
    public final Array<Animation> animations = new Array();

    public void load(Array<GLTFAnimation> glAnimations, NodeResolver nodeResolver, DataResolver dataResolver) {
        if (glAnimations != null) {
            for (int i = 0; i < glAnimations.size; ++i) {
                GLTFAnimation glAnimation = (GLTFAnimation)glAnimations.get(i);
                Animation animation = this.load(glAnimation, nodeResolver, dataResolver);
                animation.id = glAnimation.name == null ? "animation" + i : glAnimation.name;
                this.animations.add((Object)animation);
            }
        }
    }

    private Animation load(GLTFAnimation glAnimation, NodeResolver nodeResolver, DataResolver dataResolver) {
        ObjectMap animMap = new ObjectMap();
        Animation animation = new Animation();
        for (GLTFAnimationChannel glChannel : glAnimation.channels) {
            GLTFAnimationSampler glSampler = (GLTFAnimationSampler)glAnimation.samplers.get(glChannel.sampler.intValue());
            Node node = nodeResolver.get(glChannel.target.node);
            NodeAnimation nodeAnimation = (NodeAnimation)animMap.get((Object)node);
            if (nodeAnimation == null) {
                nodeAnimation = new NodeAnimationHack();
                nodeAnimation.node = node;
                animMap.put((Object)node, (Object)nodeAnimation);
                animation.nodeAnimations.add((Object)nodeAnimation);
            }
            float[] inputData = dataResolver.readBufferFloat(glSampler.input);
            float[] outputData = dataResolver.readBufferFloat(glSampler.output);
            Interpolation interpolation = GLTFTypes.mapInterpolation(glSampler.interpolation);
            int dataOffset = 0;
            int dataStride = 1;
            if (interpolation == Interpolation.CUBICSPLINE) {
                dataOffset = 1;
                dataStride = 3;
            }
            GLTFAccessor inputAccessor = dataResolver.getAccessor(glSampler.input);
            animation.duration = Math.max(animation.duration, inputAccessor.max[0]);
            String property = glChannel.target.path;
            if ("translation".equals(property)) {
                ((NodeAnimationHack)nodeAnimation).translationMode = interpolation;
                nodeAnimation.translation = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        nodeAnimation.translation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicVector3(), outputData, 0)));
                    }
                    for (int k = 0; k < inputData.length; ++k) {
                        nodeAnimation.translation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicVector3(), outputData, k * dataStride * 3)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    nodeAnimation.translation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new Vector3(), outputData, dataOffset * 3)));
                }
                for (int k = 0; k < inputData.length; ++k) {
                    nodeAnimation.translation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new Vector3(), outputData, (dataOffset + k * dataStride) * 3)));
                }
                continue;
            }
            if ("rotation".equals(property)) {
                ((NodeAnimationHack)nodeAnimation).rotationMode = interpolation;
                nodeAnimation.rotation = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        nodeAnimation.rotation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicQuaternion(), outputData, 0)));
                    }
                    for (int k = 0; k < inputData.length; ++k) {
                        nodeAnimation.rotation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicQuaternion(), outputData, k * dataStride * 4)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    nodeAnimation.rotation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new Quaternion(), outputData, dataOffset * 4)));
                }
                for (int k = 0; k < inputData.length; ++k) {
                    nodeAnimation.rotation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new Quaternion(), outputData, (dataOffset + k * dataStride) * 4)));
                }
                continue;
            }
            if ("scale".equals(property)) {
                ((NodeAnimationHack)nodeAnimation).scalingMode = interpolation;
                nodeAnimation.scaling = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        nodeAnimation.scaling.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicVector3(), outputData, 0)));
                    }
                    for (int k = 0; k < inputData.length; ++k) {
                        nodeAnimation.scaling.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicVector3(), outputData, k * dataStride * 3)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    nodeAnimation.scaling.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new Vector3(), outputData, dataOffset * 3)));
                }
                for (int k = 0; k < inputData.length; ++k) {
                    nodeAnimation.scaling.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new Vector3(), outputData, (dataOffset + k * dataStride) * 3)));
                }
                continue;
            }
            if ("weights".equals(property)) {
                int k;
                ((NodeAnimationHack)nodeAnimation).weightsMode = interpolation;
                NodeAnimationHack np = (NodeAnimationHack)nodeAnimation;
                int nbWeights = ((NodePlus)node).weights.count;
                np.weights = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        np.weights.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicWeightVector(nbWeights), outputData, 0)));
                    }
                    for (k = 0; k < inputData.length; ++k) {
                        np.weights.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicWeightVector(nbWeights), outputData, k * dataStride * nbWeights)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    np.weights.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new WeightVector(nbWeights), outputData, dataOffset * nbWeights)));
                }
                for (k = 0; k < inputData.length; ++k) {
                    np.weights.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new WeightVector(nbWeights), outputData, (dataOffset + k * dataStride) * nbWeights)));
                }
                continue;
            }
            throw new GdxRuntimeException("unsupported " + property);
        }
        return animation;
    }
}

