/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.Iterator;
import net.mgsx.gltf.data.GLTF;
import net.mgsx.gltf.data.camera.GLTFCamera;
import net.mgsx.gltf.data.extensions.KHRLightsPunctual;
import net.mgsx.gltf.data.geometry.GLTFMesh;
import net.mgsx.gltf.data.scene.GLTFNode;
import net.mgsx.gltf.data.scene.GLTFScene;
import net.mgsx.gltf.loaders.shared.GLTFTypes;
import net.mgsx.gltf.loaders.shared.animation.AnimationLoader;
import net.mgsx.gltf.loaders.shared.data.DataFileResolver;
import net.mgsx.gltf.loaders.shared.data.DataResolver;
import net.mgsx.gltf.loaders.shared.geometry.MeshLoader;
import net.mgsx.gltf.loaders.shared.material.MaterialLoader;
import net.mgsx.gltf.loaders.shared.material.PBRMaterialLoader;
import net.mgsx.gltf.loaders.shared.scene.NodeResolver;
import net.mgsx.gltf.loaders.shared.scene.SkinLoader;
import net.mgsx.gltf.loaders.shared.texture.ImageResolver;
import net.mgsx.gltf.loaders.shared.texture.TextureResolver;
import net.mgsx.gltf.scene3d.model.NodePlus;
import net.mgsx.gltf.scene3d.scene.SceneAsset;
import net.mgsx.gltf.scene3d.scene.SceneModel;

public class GLTFLoaderBase
implements Disposable {
    public static final String TAG = "GLTF";
    private final Array<Camera> cameras = new Array();
    private final Array<BaseLight> lights = new Array();
    private ObjectMap<String, Integer> lightMap = new ObjectMap();
    private ObjectMap<String, Integer> cameraMap = new ObjectMap();
    private Array<SceneModel> scenes = new Array();
    protected GLTF glModel;
    protected DataFileResolver dataFileResolver;
    protected MaterialLoader materialLoader;
    protected TextureResolver textureResolver;
    protected AnimationLoader animationLoader;
    protected DataResolver dataResolver;
    protected SkinLoader skinLoader;
    protected NodeResolver nodeResolver;
    protected MeshLoader meshLoader;
    protected ImageResolver imageResolver;

    public GLTFLoaderBase() {
        this(null);
    }

    public GLTFLoaderBase(TextureResolver textureResolver) {
        this.textureResolver = textureResolver;
        this.animationLoader = new AnimationLoader();
        this.nodeResolver = new NodeResolver();
        this.meshLoader = new MeshLoader();
        this.skinLoader = new SkinLoader();
    }

    public SceneAsset load(DataFileResolver dataFileResolver, boolean withData) {
        try {
            this.dataFileResolver = dataFileResolver;
            this.glModel = dataFileResolver.getRoot();
            if (this.glModel.extensionsRequired != null) {
                for (String extension : this.glModel.extensionsRequired) {
                    if ("KHR_materials_pbrSpecularGlossiness".equals(extension) || "KHR_texture_transform".equals(extension) || "KHR_lights_punctual".equals(extension) || "KHR_materials_unlit".equals(extension)) continue;
                    throw new GdxRuntimeException("Extension " + extension + " required but not supported");
                }
            }
            this.dataResolver = new DataResolver(this.glModel, dataFileResolver);
            if (this.textureResolver == null) {
                this.imageResolver = new ImageResolver(dataFileResolver);
                this.imageResolver.load(this.glModel.images);
                this.textureResolver = new TextureResolver();
                this.textureResolver.loadTextures(this.glModel.textures, this.glModel.samplers, this.imageResolver);
                this.imageResolver.dispose();
            }
            this.materialLoader = new PBRMaterialLoader(this.textureResolver);
            this.materialLoader.loadMaterials(this.glModel.materials);
            this.loadCameras();
            this.loadLights();
            this.loadScenes();
            this.animationLoader.load(this.glModel.animations, this.nodeResolver, this.dataResolver);
            this.skinLoader.load(this.glModel.skins, this.glModel.nodes, this.nodeResolver, this.dataResolver);
            SceneAsset model = new SceneAsset();
            if (withData) {
                model.data = this.glModel;
            }
            model.scenes = this.scenes;
            model.scene = (SceneModel)this.scenes.get(this.glModel.scene);
            model.maxBones = this.meshLoader.getMaxBones();
            model.textures = this.textureResolver.getTextures((Array<Texture>)new Array());
            model.animations = this.animationLoader.animations;
            for (SceneModel scene : model.scenes) {
                scene.model.animations.addAll(this.animationLoader.animations);
            }
            return model;
        }
        catch (RuntimeException e) {
            this.dispose();
            throw e;
        }
    }

    private void loadLights() {
        KHRLightsPunctual.GLTFLights lightExt;
        if (this.glModel.extensions != null && (lightExt = this.glModel.extensions.get(KHRLightsPunctual.GLTFLights.class, "KHR_lights_punctual")) != null) {
            for (KHRLightsPunctual.GLTFLight light : lightExt.lights) {
                this.lights.add((Object)KHRLightsPunctual.map(light));
            }
        }
    }

    public void dispose() {
        if (this.imageResolver != null) {
            this.imageResolver.dispose();
        }
        if (this.textureResolver != null) {
            this.textureResolver.dispose();
        }
        for (SceneModel scene : this.scenes) {
            scene.dispose();
        }
    }

    private void loadScenes() {
        for (int i = 0; i < this.glModel.scenes.size; ++i) {
            this.scenes.add((Object)this.loadScene((GLTFScene)this.glModel.scenes.get(i)));
        }
    }

    private void loadCameras() {
        if (this.glModel.cameras != null) {
            for (GLTFCamera glCamera : this.glModel.cameras) {
                this.cameras.add((Object)GLTFTypes.map(glCamera));
            }
        }
    }

    private SceneModel loadScene(GLTFScene gltfScene) {
        Node node;
        SceneModel sceneModel = new SceneModel();
        sceneModel.name = gltfScene.name;
        sceneModel.model = new Model();
        if (gltfScene.nodes != null) {
            Iterator iterator = gltfScene.nodes.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                sceneModel.model.nodes.add((Object)this.getNode(id));
            }
        }
        for (ObjectMap.Entry entry : this.cameraMap) {
            node = sceneModel.model.getNode((String)entry.key, true);
            if (node == null) continue;
            sceneModel.cameras.put((Object)node, this.cameras.get(((Integer)entry.value).intValue()));
        }
        for (ObjectMap.Entry entry : this.lightMap) {
            node = sceneModel.model.getNode((String)entry.key, true);
            if (node == null) continue;
            sceneModel.lights.put((Object)node, this.lights.get(((Integer)entry.value).intValue()));
        }
        sceneModel.model.meshes.addAll(this.meshLoader.getMeshes());
        return sceneModel;
    }

    private Node getNode(int id) {
        Node node = this.nodeResolver.get(id);
        if (node == null) {
            KHRLightsPunctual.GLTFLightNode nodeLight;
            Object matrix;
            node = new NodePlus();
            this.nodeResolver.put(id, node);
            GLTFNode glNode = (GLTFNode)this.glModel.nodes.get(id);
            if (glNode.matrix != null) {
                matrix = new Matrix4(glNode.matrix);
                matrix.getTranslation(node.translation);
                matrix.getScale(node.scale);
                matrix.getRotation(node.rotation);
            } else {
                if (glNode.translation != null) {
                    GLTFTypes.map(node.translation, glNode.translation);
                }
                if (glNode.rotation != null) {
                    GLTFTypes.map(node.rotation, glNode.rotation);
                }
                if (glNode.scale != null) {
                    GLTFTypes.map(node.scale, glNode.scale);
                }
            }
            String string = node.id = glNode.name == null ? "glNode " + id : glNode.name;
            if (glNode.children != null) {
                matrix = glNode.children.iterator();
                while (matrix.hasNext()) {
                    int childId = (Integer)matrix.next();
                    node.addChild(this.getNode(childId));
                }
            }
            if (glNode.mesh != null) {
                this.meshLoader.load(node, (GLTFMesh)this.glModel.meshes.get(glNode.mesh.intValue()), this.dataResolver, this.materialLoader);
            }
            if (glNode.camera != null) {
                this.cameraMap.put((Object)node.id, (Object)glNode.camera);
            }
            if (glNode.extensions != null && (nodeLight = glNode.extensions.get(KHRLightsPunctual.GLTFLightNode.class, "KHR_lights_punctual")) != null) {
                this.lightMap.put((Object)node.id, (Object)nodeLight.light);
            }
        }
        return node;
    }
}

