/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.gltf;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.mgsx.gltf.data.GLTF;
import net.mgsx.gltf.data.data.GLTFBuffer;
import net.mgsx.gltf.data.texture.GLTFImage;
import net.mgsx.gltf.loaders.exceptions.GLTFIllegalException;
import net.mgsx.gltf.loaders.shared.data.DataFileResolver;
import net.mgsx.gltf.loaders.shared.texture.PixmapBinaryLoaderHack;

public class SeparatedDataFileResolver
implements DataFileResolver {
    private ObjectMap<Integer, ByteBuffer> bufferMap = new ObjectMap();
    private GLTF glModel;
    private FileHandle path;

    @Override
    public void load(FileHandle file) {
        this.glModel = (GLTF)new Json().fromJson(GLTF.class, file);
        this.path = file.parent();
        this.loadBuffers(this.path);
    }

    @Override
    public GLTF getRoot() {
        return this.glModel;
    }

    private ObjectMap<Integer, ByteBuffer> loadBuffers(FileHandle path) {
        if (this.glModel.buffers != null) {
            for (int i = 0; i < this.glModel.buffers.size; ++i) {
                GLTFBuffer glBuffer = (GLTFBuffer)this.glModel.buffers.get(i);
                ByteBuffer buffer = ByteBuffer.allocate(glBuffer.byteLength);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (glBuffer.uri.startsWith("data:")) {
                    String[] headerBody = glBuffer.uri.split(",", 2);
                    String header = headerBody[0];
                    String body = headerBody[1];
                    byte[] data = Base64Coder.decode((String)body);
                    buffer.put(data);
                } else {
                    FileHandle file = path.child(glBuffer.uri);
                    buffer.put(file.readBytes());
                }
                this.bufferMap.put((Object)i, (Object)buffer);
            }
        }
        return this.bufferMap;
    }

    @Override
    public ByteBuffer getBuffer(int buffer) {
        return (ByteBuffer)this.bufferMap.get((Object)buffer);
    }

    @Override
    public Pixmap load(GLTFImage glImage) {
        if (glImage.uri == null) {
            throw new GLTFIllegalException("GLTF image URI cannot be null");
        }
        if (glImage.uri.startsWith("data:")) {
            String[] headerBody = glImage.uri.split(",", 2);
            String header = headerBody[0];
            System.out.println(header);
            String body = headerBody[1];
            byte[] data = Base64Coder.decode((String)body);
            return PixmapBinaryLoaderHack.load(data, 0, data.length);
        }
        return new Pixmap(this.path.child(glImage.uri));
    }

    public FileHandle getImageFile(GLTFImage glImage) {
        if (glImage.uri != null && !glImage.uri.startsWith("data:")) {
            return this.path.child(glImage.uri);
        }
        return null;
    }
}

