/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.FloatBuffer;
import net.mgsx.gltf.data.data.GLTFAccessor;
import net.mgsx.gltf.data.scene.GLTFNode;
import net.mgsx.gltf.data.scene.GLTFSkin;
import net.mgsx.gltf.exporters.GLTFExporter;

class GLTFSkinExporter {
    private final GLTFExporter base;

    public GLTFSkinExporter(GLTFExporter base) {
        this.base = base;
    }

    public void export() {
        for (int i = 0; i < this.base.nodeMapping.size; ++i) {
            Node node = (Node)this.base.nodeMapping.get(i);
            GLTFNode glNode = (GLTFNode)this.base.root.nodes.get(i);
            if (glNode.skin != null || node.parts == null) continue;
            for (NodePart part : node.parts) {
                if (part.invBoneBindTransforms == null) continue;
                GLTFSkin skin = new GLTFSkin();
                if (this.base.root.skins == null) {
                    this.base.root.skins = new Array();
                }
                this.base.root.skins.add((Object)skin);
                glNode.skin = this.base.root.skins.size - 1;
                skin.joints = new Array();
                FloatBuffer matrixBuffer = this.base.binManager.beginFloats(part.invBoneBindTransforms.size * 16);
                for (ObjectMap.Entry e : part.invBoneBindTransforms) {
                    int boneID = this.base.nodeMapping.indexOf(e.key, true);
                    skin.joints.add((Object)boneID);
                    matrixBuffer.put(((Matrix4)e.value).val);
                }
                GLTFAccessor accessor = this.base.obtainAccessor();
                accessor.bufferView = this.base.binManager.end();
                accessor.type = "MAT4";
                accessor.componentType = 5126;
                accessor.count = part.invBoneBindTransforms.size;
                skin.inverseBindMatrices = this.base.root.accessors.size - 1;
            }
        }
    }
}

