/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import net.mgsx.gltf.data.GLTFExtensions;
import net.mgsx.gltf.data.extensions.KHRLightsPunctual;
import net.mgsx.gltf.data.scene.GLTFNode;
import net.mgsx.gltf.exporters.GLTFExportTypes;
import net.mgsx.gltf.exporters.GLTFExporter;
import net.mgsx.gltf.scene3d.lights.DirectionalLightEx;
import net.mgsx.gltf.scene3d.lights.PointLightEx;
import net.mgsx.gltf.scene3d.lights.SpotLightEx;

class GLTFLightExporter {
    private GLTFExporter base;

    public GLTFLightExporter(GLTFExporter base) {
        this.base = base;
    }

    public void export(ObjectMap<Node, BaseLight> lights) {
        if (this.base.root.extensionsUsed == null) {
            this.base.root.extensionsUsed = new Array();
        }
        if (!this.base.root.extensionsUsed.contains((Object)"KHR_lights_punctual", false)) {
            this.base.root.extensionsUsed.add((Object)"KHR_lights_punctual");
        }
        if (this.base.root.extensionsRequired == null) {
            this.base.root.extensionsRequired = new Array();
        }
        if (!this.base.root.extensionsRequired.contains((Object)"KHR_lights_punctual", false)) {
            this.base.root.extensionsRequired.add((Object)"KHR_lights_punctual");
        }
        for (ObjectMap.Entry entry : lights) {
            KHRLightsPunctual.GLTFLightNode nodeLight;
            KHRLightsPunctual.GLTFLights extLights;
            int nodeID = this.base.nodeMapping.indexOf(entry.key, true);
            if (nodeID < 0) {
                throw new GdxRuntimeException("node not found");
            }
            GLTFNode glNode = (GLTFNode)this.base.root.nodes.get(nodeID);
            if (this.base.root.extensions == null) {
                this.base.root.extensions = new GLTFExtensions();
            }
            if ((extLights = this.base.root.extensions.get(KHRLightsPunctual.GLTFLights.class, "KHR_lights_punctual")) == null) {
                extLights = new KHRLightsPunctual.GLTFLights();
                this.base.root.extensions.set("KHR_lights_punctual", extLights);
            }
            if (extLights.lights == null) {
                extLights.lights = new Array();
            }
            KHRLightsPunctual.GLTFLight glLight = GLTFLightExporter.map(new KHRLightsPunctual.GLTFLight(), (BaseLight)entry.value);
            glLight.name = glNode.name;
            extLights.lights.add((Object)glLight);
            if (glNode.extensions == null) {
                glNode.extensions = new GLTFExtensions();
            }
            if ((nodeLight = glNode.extensions.get(KHRLightsPunctual.GLTFLightNode.class, "KHR_lights_punctual")) == null) {
                nodeLight = new KHRLightsPunctual.GLTFLightNode();
                glNode.extensions.set("KHR_lights_punctual", nodeLight);
            }
            nodeLight.light = extLights.lights.size - 1;
        }
    }

    public static KHRLightsPunctual.GLTFLight map(KHRLightsPunctual.GLTFLight glLight, BaseLight light) {
        float intensityScale;
        if (light instanceof DirectionalLight) {
            glLight.type = "directional";
            glLight.intensity = light instanceof DirectionalLightEx ? ((DirectionalLightEx)light).intensity : 1.0f;
            intensityScale = 1.0f;
        } else if (light instanceof PointLight) {
            glLight.type = "point";
            if (light instanceof PointLightEx) {
                glLight.intensity = ((PointLightEx)light).intensity;
                glLight.range = ((PointLightEx)light).range;
            } else {
                glLight.intensity = 1.0f;
            }
            intensityScale = 10.0f;
        } else if (light instanceof SpotLight) {
            glLight.type = "spot";
            glLight.spot = new KHRLightsPunctual.GLTFSpotLight();
            if (light instanceof SpotLightEx) {
                glLight.intensity = ((SpotLightEx)light).intensity;
                glLight.range = ((SpotLightEx)light).range;
            } else {
                glLight.intensity = 1.0f;
            }
            intensityScale = 10.0f;
            float cosDeltaAngle = 1.0f / ((SpotLight)light).exponent;
            float cosOuterAngle = -((SpotLight)light).cutoffAngle / ((SpotLight)light).exponent;
            glLight.spot.outerConeAngle = (float)Math.acos(cosOuterAngle);
            glLight.spot.innerConeAngle = (float)Math.acos(cosOuterAngle + cosDeltaAngle);
        } else {
            throw new GdxRuntimeException("unsupported light type " + light.getClass());
        }
        glLight.color = GLTFExportTypes.rgb(light.color.cpy().mul(1.0f / glLight.intensity));
        glLight.intensity *= intensityScale;
        return glLight;
    }
}

