/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import net.mgsx.gltf.data.GLTF;
import net.mgsx.gltf.data.GLTFAsset;
import net.mgsx.gltf.data.data.GLTFAccessor;
import net.mgsx.gltf.data.geometry.GLTFMesh;
import net.mgsx.gltf.data.geometry.GLTFPrimitive;
import net.mgsx.gltf.data.scene.GLTFNode;
import net.mgsx.gltf.data.scene.GLTFScene;
import net.mgsx.gltf.exporters.GLTFAnimationExporter;
import net.mgsx.gltf.exporters.GLTFBinaryExporter;
import net.mgsx.gltf.exporters.GLTFCameraExporter;
import net.mgsx.gltf.exporters.GLTFExportTypes;
import net.mgsx.gltf.exporters.GLTFExporterConfig;
import net.mgsx.gltf.exporters.GLTFLightExporter;
import net.mgsx.gltf.exporters.GLTFMaterialExporter;
import net.mgsx.gltf.exporters.GLTFMeshExporter;
import net.mgsx.gltf.exporters.GLTFSkinExporter;
import net.mgsx.gltf.scene3d.scene.Scene;
import net.mgsx.gltf.scene3d.scene.SceneAsset;
import net.mgsx.gltf.scene3d.scene.SceneModel;

public class GLTFExporter {
    private static final String GENERATOR_INFO = "GDX glTF exporter 1.0";
    GLTF root;
    GLTFBinaryExporter binManager;
    private final GLTFMeshExporter meshExporter;
    final Array<Node> nodeMapping = new Array();
    final Array<Material> materialMapping = new Array();
    final Array<Texture> textureMapping = new Array();
    protected int textureFileIndex;
    private final GLTFExporterConfig config;

    public GLTFExporter() {
        this(new GLTFExporterConfig());
    }

    public GLTFExporter(GLTFExporterConfig config) {
        this.config = config;
        this.meshExporter = new GLTFMeshExporter(this);
    }

    protected String getImageName(Texture texture) {
        String name = "texture" + this.textureFileIndex;
        ++this.textureFileIndex;
        return name;
    }

    private void reset() {
        this.root = null;
        this.binManager.reset();
        this.nodeMapping.clear();
        this.materialMapping.clear();
        this.textureMapping.clear();
        this.textureFileIndex = 0;
    }

    public void export(Mesh mesh, int primitiveType, FileHandle file) {
        GLTFScene scene = this.beginSingleScene(file);
        GLTFNode glNode = this.obtainNode();
        scene.nodes = new Array();
        scene.nodes.add((Object)(this.root.nodes.size - 1));
        GLTFMesh gltfMesh = this.obtainMesh();
        glNode.mesh = this.root.meshes.size - 1;
        MeshPart meshPart = new MeshPart();
        meshPart.mesh = mesh;
        meshPart.offset = 0;
        meshPart.primitiveType = primitiveType;
        meshPart.size = mesh.getNumIndices();
        if (meshPart.size == 0) {
            meshPart.size = mesh.getNumVertices();
        }
        gltfMesh.primitives = new Array();
        GLTFPrimitive primitive = this.meshExporter.exportMeshPart(meshPart);
        gltfMesh.primitives.add((Object)primitive);
        this.end(file);
    }

    public void export(Model model, FileHandle file) {
        GLTFScene scene = this.beginSingleScene(file);
        new GLTFMaterialExporter(this).export((Iterable<Node>)model.nodes);
        scene.nodes = this.exportNodes(scene, (Iterable<Node>)model.nodes);
        new GLTFSkinExporter(this).export();
        new GLTFAnimationExporter(this).export((Array<Animation>)model.animations);
        this.end(file);
    }

    public void export(Scene scene, FileHandle file) {
        GLTFScene glScene = this.beginSingleScene(file);
        this.exportScene(glScene, scene);
        this.end(file);
    }

    public void export(SceneModel scene, FileHandle file) {
        GLTFScene glScene = this.beginSingleScene(file);
        this.exportScene(glScene, scene);
        this.end(file);
    }

    private void exportScene(GLTFScene glScene, Scene scene) {
        new GLTFMaterialExporter(this).export((Iterable<Node>)scene.modelInstance.nodes);
        glScene.nodes = this.exportNodes(glScene, (Iterable<Node>)scene.modelInstance.nodes);
        if (this.config.exportCameras) {
            new GLTFCameraExporter(this).export(scene.cameras);
        }
        if (this.config.exportLights) {
            new GLTFLightExporter(this).export(scene.lights);
        }
        new GLTFSkinExporter(this).export();
        new GLTFAnimationExporter(this).export((Array<Animation>)scene.modelInstance.animations);
    }

    private void exportScene(GLTFScene glScene, SceneModel scene) {
        new GLTFMaterialExporter(this).export((Iterable<Node>)scene.model.nodes);
        glScene.nodes = this.exportNodes(glScene, (Iterable<Node>)scene.model.nodes);
        if (this.config.exportCameras) {
            new GLTFCameraExporter(this).export(scene.cameras);
        }
        if (this.config.exportLights) {
            new GLTFLightExporter(this).export(scene.lights);
        }
        new GLTFSkinExporter(this).export();
        new GLTFAnimationExporter(this).export((Array<Animation>)scene.model.animations);
    }

    public void export(SceneAsset asset, FileHandle file) {
        this.export(asset.scenes, asset.scene, file);
    }

    public void export(Array<SceneModel> scenes, SceneModel defaultScene, FileHandle file) {
        this.beginMultiScene(file);
        for (SceneModel scene : scenes) {
            GLTFScene glScene = this.obtainScene();
            this.exportScene(glScene, scene);
        }
        this.root.scene = scenes.indexOf((Object)defaultScene, true);
        if (this.root.scene < 0) {
            throw new GdxRuntimeException("scene not found");
        }
        this.end(file);
    }

    public void export(Array<Scene> scenes, Scene defaultScene, FileHandle file) {
        this.beginMultiScene(file);
        for (Scene scene : scenes) {
            GLTFScene glScene = this.obtainScene();
            this.exportScene(glScene, scene);
        }
        this.root.scene = scenes.indexOf((Object)defaultScene, true);
        if (this.root.scene < 0) {
            throw new GdxRuntimeException("scene not found");
        }
        this.end(file);
    }

    private void beginMultiScene(FileHandle file) {
        this.binManager = new GLTFBinaryExporter(file.parent(), this.config);
        this.root = new GLTF();
        this.root.asset = new GLTFAsset();
        this.root.asset.version = "2.0";
        this.root.asset.generator = GENERATOR_INFO;
        this.root.scenes = new Array();
    }

    private GLTFScene beginSingleScene(FileHandle file) {
        this.beginMultiScene(file);
        this.root.scene = 0;
        return this.obtainScene();
    }

    private GLTFScene obtainScene() {
        GLTFScene scene = new GLTFScene();
        this.root.scenes.add((Object)scene);
        return scene;
    }

    private void end(FileHandle file) {
        this.root.bufferViews = this.binManager.views;
        this.root.buffers = this.binManager.flushAllToFiles(file.nameWithoutExtension());
        Json json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        json.setUsePrototypes(true);
        file.writeString(json.prettyPrint((Object)this.root), false);
        this.reset();
    }

    private Array<Integer> exportNodes(GLTFScene scene, Iterable<Node> nodes) {
        Array indices = null;
        for (Node node : nodes) {
            GLTFNode data = this.obtainNode();
            this.nodeMapping.add((Object)node);
            data.name = node.id;
            if (!node.translation.isZero()) {
                data.translation = GLTFExportTypes.toArray(node.translation);
            }
            if (!node.scale.epsilonEquals(1.0f, 1.0f, 1.0f)) {
                data.scale = GLTFExportTypes.toArray(node.scale);
            }
            if (!node.rotation.isIdentity()) {
                data.rotation = GLTFExportTypes.toArray(node.rotation);
            }
            if (indices == null) {
                indices = new Array();
            }
            indices.add((Object)(this.root.nodes.size - 1));
            if (node.parts.size > 0) {
                GLTFMesh gltfMesh = this.obtainMesh();
                data.mesh = this.root.meshes.size - 1;
                gltfMesh.primitives = new Array();
                for (NodePart nodePart : node.parts) {
                    GLTFPrimitive primitive = this.meshExporter.exportMeshPart(nodePart.meshPart);
                    int materialIndex = this.materialMapping.indexOf((Object)nodePart.material, true);
                    if (materialIndex < 0) {
                        throw new GdxRuntimeException("material not found");
                    }
                    primitive.material = materialIndex;
                    gltfMesh.primitives.add((Object)primitive);
                }
            }
            data.children = this.exportNodes(scene, node.getChildren());
        }
        return indices;
    }

    GLTFAccessor obtainAccessor() {
        GLTFAccessor a = new GLTFAccessor();
        if (this.root.accessors == null) {
            this.root.accessors = new Array();
        }
        this.root.accessors.add((Object)a);
        return a;
    }

    private GLTFNode obtainNode() {
        GLTFNode data = new GLTFNode();
        if (this.root.nodes == null) {
            this.root.nodes = new Array();
        }
        this.root.nodes.add((Object)data);
        return data;
    }

    private GLTFMesh obtainMesh() {
        GLTFMesh data = new GLTFMesh();
        if (this.root.meshes == null) {
            this.root.meshes = new Array();
        }
        this.root.meshes.add((Object)data);
        return data;
    }
}

