/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;

class GLTFExportTypes {
    GLTFExportTypes() {
    }

    static float[] rgb(ColorAttribute a) {
        return a == null ? null : GLTFExportTypes.rgb(a.color);
    }

    static float[] rgba(ColorAttribute a) {
        return a == null ? null : GLTFExportTypes.rgba(a.color);
    }

    static float[] rgb(Color color) {
        float[] fArray;
        if (color == null) {
            fArray = null;
        } else {
            float[] fArray2 = new float[3];
            fArray2[0] = color.r;
            fArray2[1] = color.g;
            fArray = fArray2;
            fArray2[2] = color.b;
        }
        return fArray;
    }

    static float[] rgba(Color color) {
        float[] fArray;
        if (color == null) {
            fArray = null;
        } else {
            float[] fArray2 = new float[4];
            fArray2[0] = color.r;
            fArray2[1] = color.g;
            fArray2[2] = color.b;
            fArray = fArray2;
            fArray2[3] = color.a;
        }
        return fArray;
    }

    static float[] rgb(Color color, Color nullColor) {
        return color.equals((Object)nullColor) ? null : GLTFExportTypes.rgb(color);
    }

    static float[] toArray(Vector3 v) {
        return new float[]{v.x, v.y, v.z};
    }

    static float[] toArray(Quaternion v) {
        return new float[]{v.x, v.y, v.z, v.w};
    }
}

