/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import net.mgsx.gltf.data.data.GLTFBuffer;
import net.mgsx.gltf.data.data.GLTFBufferView;
import net.mgsx.gltf.data.texture.GLTFImage;
import net.mgsx.gltf.exporters.GLTFExporterConfig;

class GLTFBinaryExporter {
    private final Array<ByteBuffer> buffers = new Array();
    final Array<GLTFBufferView> views = new Array();
    private Buffer currentBuffer;
    private FileHandle folder;
    private final GLTFExporterConfig config;

    public GLTFBinaryExporter(FileHandle folder, GLTFExporterConfig config) {
        this.config = config;
        this.folder = folder;
    }

    void reset() {
        this.buffers.clear();
        this.views.clear();
        this.currentBuffer = null;
    }

    private ByteBuffer createBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.config.maxBinaryFileSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    private ByteBuffer begin(int size) {
        ByteBuffer buffer;
        if (this.buffers.size == 0) {
            buffer = this.createBuffer();
            this.buffers.add((Object)buffer);
        } else {
            buffer = (ByteBuffer)this.buffers.peek();
            if (buffer.remaining() < size) {
                buffer = this.createBuffer();
                this.buffers.add((Object)buffer);
            }
        }
        return buffer;
    }

    public FloatBuffer beginFloats(int count) {
        FloatBuffer floatBuffer = this.begin(count * 4).asFloatBuffer();
        this.currentBuffer = floatBuffer;
        return floatBuffer;
    }

    public ShortBuffer beginShorts(int count) {
        ShortBuffer shortBuffer = this.begin(count * 2).asShortBuffer();
        this.currentBuffer = shortBuffer;
        return shortBuffer;
    }

    public int end() {
        int size;
        int position;
        GLTFBufferView view = new GLTFBufferView();
        view.buffer = this.buffers.size - 1;
        view.byteOffset = position = ((ByteBuffer)this.buffers.peek()).position();
        if (this.currentBuffer instanceof FloatBuffer) {
            size = this.currentBuffer.position() * 4;
        } else if (this.currentBuffer instanceof ShortBuffer) {
            size = this.currentBuffer.position() * 2;
        } else {
            throw new GdxRuntimeException("bad buffer type...");
        }
        this.currentBuffer = null;
        view.byteLength = size;
        ((ByteBuffer)this.buffers.peek()).position(position += size);
        this.views.add((Object)view);
        return this.views.size - 1;
    }

    public Array<GLTFBuffer> flushAllToFiles(String baseName) {
        Array out = new Array();
        int count = 0;
        for (ByteBuffer b : this.buffers) {
            GLTFBuffer buffer = new GLTFBuffer();
            buffer.byteLength = b.position();
            buffer.uri = this.buffers.size == 1 ? baseName + ".bin" : baseName + (count + 1) + ".bin";
            byte[] bytes = new byte[b.position()];
            b.flip();
            b.get(bytes);
            this.folder.child(buffer.uri).writeBytes(bytes, false);
            out.add((Object)buffer);
        }
        return out;
    }

    public void export(GLTFImage image, Texture texture, String baseName) {
        String fileName;
        image.uri = fileName = baseName + ".png";
        FileHandle file = this.folder.child(fileName);
        FrameBuffer fbo = new FrameBuffer(texture.getTextureData().getFormat(), texture.getWidth(), texture.getHeight(), false);
        fbo.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        SpriteBatch batch = new SpriteBatch();
        batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1.0f, 1.0f);
        batch.setBlendFunction(770, 1);
        batch.begin();
        batch.draw(texture, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        batch.end();
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap((int)0, (int)0, (int)texture.getWidth(), (int)texture.getHeight());
        fbo.end();
        batch.dispose();
        fbo.dispose();
        GLTFBinaryExporter.savePNG(file, pixmap);
        pixmap.dispose();
    }

    public static void savePNG(FileHandle file, Pixmap pixmap) {
        if (Gdx.app.getType() == Application.ApplicationType.WebGL) {
            throw new GdxRuntimeException("saving pixmap not supported for WebGL");
        }
        try {
            Class pixmapIO = ClassReflection.forName((String)"com.badlogic.gdx.graphics.PixmapIO");
            Method pixmapIO_writePNG = ClassReflection.getMethod((Class)pixmapIO, (String)"writePNG", (Class[])new Class[]{FileHandle.class, Pixmap.class});
            pixmapIO_writePNG.invoke(null, new Object[]{file, pixmap});
        }
        catch (ReflectionException e) {
            throw new GdxRuntimeException((Throwable)e);
        }
    }
}

