/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.exporters;

import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.FloatBuffer;
import net.mgsx.gltf.data.animation.GLTFAnimation;
import net.mgsx.gltf.data.animation.GLTFAnimationChannel;
import net.mgsx.gltf.data.animation.GLTFAnimationSampler;
import net.mgsx.gltf.data.animation.GLTFAnimationTarget;
import net.mgsx.gltf.data.data.GLTFAccessor;
import net.mgsx.gltf.exporters.GLTFExporter;
import net.mgsx.gltf.loaders.shared.animation.Interpolation;
import net.mgsx.gltf.scene3d.animation.NodeAnimationHack;
import net.mgsx.gltf.scene3d.model.CubicQuaternion;
import net.mgsx.gltf.scene3d.model.CubicVector3;
import net.mgsx.gltf.scene3d.model.CubicWeightVector;
import net.mgsx.gltf.scene3d.model.WeightVector;

class GLTFAnimationExporter {
    private final GLTFExporter base;
    private static final ChannelExporter<Vector3> channelExporterVector3 = new ChannelExporter<Vector3>(3, "VEC3"){

        @Override
        protected void getOutput(FloatBuffer outputs, Vector3 value) {
            if (value instanceof CubicVector3) {
                CubicVector3 cubic = (CubicVector3)value;
                outputs.put(cubic.tangentIn.x);
                outputs.put(cubic.tangentIn.y);
                outputs.put(cubic.tangentIn.z);
                outputs.put(value.x);
                outputs.put(value.y);
                outputs.put(value.z);
                outputs.put(cubic.tangentOut.x);
                outputs.put(cubic.tangentOut.y);
                outputs.put(cubic.tangentOut.z);
            } else {
                outputs.put(value.x);
                outputs.put(value.y);
                outputs.put(value.z);
            }
        }
    };
    private static final ChannelExporter<Quaternion> channelExporterQuaternion = new ChannelExporter<Quaternion>(4, "VEC4"){

        @Override
        protected void getOutput(FloatBuffer outputs, Quaternion value) {
            if (value instanceof CubicQuaternion) {
                CubicQuaternion cubic = (CubicQuaternion)value;
                outputs.put(cubic.tangentIn.x);
                outputs.put(cubic.tangentIn.y);
                outputs.put(cubic.tangentIn.z);
                outputs.put(cubic.tangentIn.w);
                outputs.put(value.x);
                outputs.put(value.y);
                outputs.put(value.z);
                outputs.put(value.w);
                outputs.put(cubic.tangentOut.x);
                outputs.put(cubic.tangentOut.y);
                outputs.put(cubic.tangentOut.z);
                outputs.put(cubic.tangentOut.w);
            } else {
                outputs.put(value.x);
                outputs.put(value.y);
                outputs.put(value.z);
                outputs.put(value.w);
            }
        }
    };

    private static ChannelExporter<WeightVector> channelExporterWeights(int count) {
        return new ChannelExporter<WeightVector>(1, "SCALAR", count){

            @Override
            protected void getOutput(FloatBuffer outputs, WeightVector value) {
                if (value instanceof CubicWeightVector) {
                    CubicWeightVector cubic = (CubicWeightVector)value;
                    outputs.put(cubic.tangentIn.values, 0, value.count);
                    outputs.put(value.values, 0, value.count);
                    outputs.put(cubic.tangentOut.values, 0, value.count);
                } else {
                    outputs.put(value.values, 0, value.count);
                }
            }
        };
    }

    public GLTFAnimationExporter(GLTFExporter base) {
        this.base = base;
    }

    public void export(Array<Animation> animations) {
        for (Animation animation : animations) {
            this.export(animation);
        }
    }

    private void export(Animation animation) {
        GLTFAnimation a = new GLTFAnimation();
        a.name = animation.id;
        if (this.base.root.animations == null) {
            this.base.root.animations = new Array();
        }
        this.base.root.animations.add((Object)a);
        for (NodeAnimation nodeAnim : animation.nodeAnimations) {
            int nodeID = this.base.nodeMapping.indexOf((Object)nodeAnim.node, true);
            if (nodeAnim.translation != null) {
                ((ChannelExporter)GLTFAnimationExporter.channelExporterVector3).export(this.base, a, nodeID, nodeAnim.translation, "translation", this.translationInterpolation(nodeAnim));
            }
            if (nodeAnim.rotation != null) {
                ((ChannelExporter)GLTFAnimationExporter.channelExporterQuaternion).export(this.base, a, nodeID, nodeAnim.rotation, "rotation", this.rotationInterpolation(nodeAnim));
            }
            if (nodeAnim.scaling != null) {
                ((ChannelExporter)GLTFAnimationExporter.channelExporterVector3).export(this.base, a, nodeID, nodeAnim.scaling, "scale", this.scaleInterpolation(nodeAnim));
            }
            if (!(nodeAnim instanceof NodeAnimationHack)) continue;
            NodeAnimationHack nodeAnimMorph = (NodeAnimationHack)nodeAnim;
            if (nodeAnimMorph.weights == null) continue;
            int count = ((WeightVector)((NodeKeyframe)nodeAnimMorph.weights.first()).value).count;
            ((ChannelExporter)GLTFAnimationExporter.channelExporterWeights(count)).export(this.base, a, nodeID, nodeAnimMorph.weights, "weights", nodeAnimMorph.weightsMode);
        }
    }

    private Interpolation translationInterpolation(NodeAnimation nodeAnim) {
        if (nodeAnim instanceof NodeAnimationHack) {
            return ((NodeAnimationHack)nodeAnim).translationMode;
        }
        return null;
    }

    private Interpolation rotationInterpolation(NodeAnimation nodeAnim) {
        if (nodeAnim instanceof NodeAnimationHack) {
            return ((NodeAnimationHack)nodeAnim).rotationMode;
        }
        return null;
    }

    private Interpolation scaleInterpolation(NodeAnimation nodeAnim) {
        if (nodeAnim instanceof NodeAnimationHack) {
            return ((NodeAnimationHack)nodeAnim).scalingMode;
        }
        return null;
    }

    public static String mapInterpolation(Interpolation type) {
        if (type == null || type == Interpolation.LINEAR) {
            return null;
        }
        if (type == Interpolation.STEP) {
            return "STEP";
        }
        if (type == Interpolation.CUBICSPLINE) {
            return "CUBICSPLINE";
        }
        throw new GdxRuntimeException("unexpected interpolation type " + (Object)((Object)type));
    }

    static abstract class ChannelExporter<T> {
        private final int numComponents;
        private final String outputType;
        private final int numElements;

        public ChannelExporter(int numComponents, String outputType) {
            this(numComponents, outputType, 1);
        }

        public ChannelExporter(int numComponents, String outputType, int numElements) {
            this.numComponents = numComponents;
            this.outputType = outputType;
            this.numElements = numElements;
        }

        private void export(GLTFExporter base, GLTFAnimation a, int nodeID, Array<NodeKeyframe<T>> keyFrames, String chanName, Interpolation interpolation) {
            if (a.channels == null) {
                a.channels = new Array();
            }
            GLTFAnimationChannel chan = new GLTFAnimationChannel();
            a.channels.add((Object)chan);
            if (a.samplers == null) {
                a.samplers = new Array();
            }
            GLTFAnimationSampler sampler = new GLTFAnimationSampler();
            a.samplers.add((Object)sampler);
            chan.sampler = a.samplers.size - 1;
            sampler.interpolation = GLTFAnimationExporter.mapInterpolation(interpolation);
            chan.target = new GLTFAnimationTarget();
            chan.target.node = nodeID;
            chan.target.path = chanName;
            int numKeyframes = keyFrames.size;
            float[] inputs = new float[numKeyframes];
            boolean cubic = interpolation == Interpolation.CUBICSPLINE;
            int interpolationFactor = cubic ? 3 : 1;
            int outputCount = numKeyframes * interpolationFactor * this.numElements;
            int outputFloats = outputCount * this.numComponents;
            FloatBuffer outputs = base.binManager.beginFloats(outputFloats);
            for (int i = 0; i < numKeyframes; ++i) {
                NodeKeyframe kf = (NodeKeyframe)keyFrames.get(i);
                inputs[i] = kf.keytime;
                this.getOutput(outputs, kf.value);
            }
            GLTFAccessor outputAccessor = base.obtainAccessor();
            outputAccessor.bufferView = base.binManager.end();
            outputAccessor.componentType = 5126;
            outputAccessor.count = outputCount;
            outputAccessor.type = this.outputType;
            sampler.output = base.root.accessors.size - 1;
            FloatBuffer inputBuffer = base.binManager.beginFloats(numKeyframes);
            inputBuffer.put(inputs);
            GLTFAccessor inputAccessor = base.obtainAccessor();
            inputAccessor.componentType = 5126;
            inputAccessor.count = numKeyframes;
            inputAccessor.type = "SCALAR";
            inputAccessor.bufferView = base.binManager.end();
            inputAccessor.min = new float[]{inputs[0]};
            inputAccessor.max = new float[]{inputs[inputs.length - 1]};
            sampler.input = base.root.accessors.size - 1;
        }

        protected abstract void getOutput(FloatBuffer var1, T var2);
    }
}

