/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.data.extensions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import net.mgsx.gltf.loaders.exceptions.GLTFIllegalException;
import net.mgsx.gltf.loaders.shared.GLTFTypes;
import net.mgsx.gltf.scene3d.lights.DirectionalLightEx;
import net.mgsx.gltf.scene3d.lights.PointLightEx;
import net.mgsx.gltf.scene3d.lights.SpotLightEx;

public abstract class KHRLightsPunctual {
    public static final String EXT = "KHR_lights_punctual";

    public static BaseLight map(GLTFLight light) {
        if ("directional".equals(light.type)) {
            DirectionalLightEx dl = new DirectionalLightEx();
            dl.baseColor.set(GLTFTypes.mapColor(light.color, Color.WHITE));
            dl.intensity = light.intensity;
            return dl;
        }
        if ("point".equals(light.type)) {
            PointLightEx pl = new PointLightEx();
            pl.color.set(GLTFTypes.mapColor(light.color, Color.WHITE));
            pl.intensity = light.intensity / 10.0f;
            pl.range = light.range;
            return pl;
        }
        if ("spot".equals(light.type)) {
            float lightAngleOffset;
            SpotLightEx sl = new SpotLightEx();
            if (light.spot == null) {
                throw new GLTFIllegalException("spot property required for spot light type");
            }
            sl.color.set(GLTFTypes.mapColor(light.color, Color.WHITE));
            sl.intensity = light.intensity / 10.0f;
            sl.range = light.range;
            float cosOuterAngle = (float)Math.cos(light.spot.outerConeAngle);
            float cosInnerAngle = (float)Math.cos(light.spot.innerConeAngle);
            float lightAngleScale = 1.0f / Math.max(0.001f, cosInnerAngle - cosOuterAngle);
            sl.cutoffAngle = lightAngleOffset = -cosOuterAngle * lightAngleScale;
            sl.exponent = lightAngleScale;
            return sl;
        }
        throw new GdxRuntimeException("unsupported light type " + light.type);
    }

    public static class GLTFLightNode {
        public Integer light;
    }

    public static class GLTFLights {
        public Array<GLTFLight> lights;
    }

    public static class GLTFLight {
        public static final String TYPE_DIRECTIONAL = "directional";
        public static final String TYPE_POINT = "point";
        public static final String TYPE_SPOT = "spot";
        public String name = "";
        public float[] color = new float[]{1.0f, 1.0f, 1.0f};
        public float intensity = 1.0f;
        public String type;
        public Float range;
        public GLTFSpotLight spot;
    }

    public static class GLTFSpotLight {
        public float innerConeAngle = 0.0f;
        public float outerConeAngle = 0.7853982f;
    }
}

