/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class MeshPlus
extends Mesh {
    private final Vector3 tmpV = new Vector3();

    public MeshPlus(boolean isStatic, int maxVertices, int maxIndices, VertexAttributes attributes) {
        super(isStatic, maxVertices, maxIndices, attributes);
    }

    public BoundingBox extendBoundingBox(BoundingBox out, int offset, int count, Matrix4 transform) {
        int max;
        int numIndices = this.getNumIndices();
        int numVertices = this.getNumVertices();
        int n = max = numIndices == 0 ? numVertices : numIndices;
        if (offset < 0 || count < 1 || offset + count > max) {
            throw new GdxRuntimeException("Invalid part specified ( offset=" + offset + ", count=" + count + ", max=" + max + " )");
        }
        FloatBuffer verts = this.vertices.getBuffer();
        ShortBuffer index = this.indices.getBuffer();
        VertexAttribute posAttrib = this.getVertexAttribute(1);
        int posoff = posAttrib.offset / 4;
        int vertexSize = this.vertices.getAttributes().vertexSize / 4;
        int end = offset + count;
        switch (posAttrib.numComponents) {
            case 1: {
                if (numIndices > 0) {
                    for (int i = offset; i < end; ++i) {
                        int idx = (index.get(i) & 0xFFFF) * vertexSize + posoff;
                        this.tmpV.set(verts.get(idx), 0.0f, 0.0f);
                        if (transform != null) {
                            this.tmpV.mul(transform);
                        }
                        out.ext(this.tmpV);
                    }
                } else {
                    for (int i = offset; i < end; ++i) {
                        int idx = i * vertexSize + posoff;
                        this.tmpV.set(verts.get(idx), 0.0f, 0.0f);
                        if (transform != null) {
                            this.tmpV.mul(transform);
                        }
                        out.ext(this.tmpV);
                    }
                }
                break;
            }
            case 2: {
                if (numIndices > 0) {
                    for (int i = offset; i < end; ++i) {
                        int idx = (index.get(i) & 0xFFFF) * vertexSize + posoff;
                        this.tmpV.set(verts.get(idx), verts.get(idx + 1), 0.0f);
                        if (transform != null) {
                            this.tmpV.mul(transform);
                        }
                        out.ext(this.tmpV);
                    }
                } else {
                    for (int i = offset; i < end; ++i) {
                        int idx = i * vertexSize + posoff;
                        this.tmpV.set(verts.get(idx), verts.get(idx + 1), 0.0f);
                        if (transform != null) {
                            this.tmpV.mul(transform);
                        }
                        out.ext(this.tmpV);
                    }
                }
                break;
            }
            case 3: {
                if (numIndices > 0) {
                    for (int i = offset; i < end; ++i) {
                        int idx = (index.get(i) & 0xFFFF) * vertexSize + posoff;
                        this.tmpV.set(verts.get(idx), verts.get(idx + 1), verts.get(idx + 2));
                        if (transform != null) {
                            this.tmpV.mul(transform);
                        }
                        out.ext(this.tmpV);
                    }
                } else {
                    for (int i = offset; i < end; ++i) {
                        int idx = i * vertexSize + posoff;
                        this.tmpV.set(verts.get(idx), verts.get(idx + 1), verts.get(idx + 2));
                        if (transform != null) {
                            this.tmpV.mul(transform);
                        }
                        out.ext(this.tmpV);
                    }
                }
                break;
            }
        }
        return out;
    }

    public float calculateRadiusSquared(float centerX, float centerY, float centerZ, int offset, int count, Matrix4 transform) {
        int numIndices = this.getNumIndices();
        if (offset < 0 || count < 1 || offset + count > numIndices) {
            throw new GdxRuntimeException("Not enough indices");
        }
        FloatBuffer verts = this.vertices.getBuffer();
        ShortBuffer index = this.indices.getBuffer();
        VertexAttribute posAttrib = this.getVertexAttribute(1);
        int posoff = posAttrib.offset / 4;
        int vertexSize = this.vertices.getAttributes().vertexSize / 4;
        int end = offset + count;
        float result = 0.0f;
        switch (posAttrib.numComponents) {
            case 1: {
                for (int i = offset; i < end; ++i) {
                    float r;
                    int idx = (index.get(i) & 0xFFFF) * vertexSize + posoff;
                    this.tmpV.set(verts.get(idx), 0.0f, 0.0f);
                    if (transform != null) {
                        this.tmpV.mul(transform);
                    }
                    if (!((r = this.tmpV.sub(centerX, centerY, centerZ).len2()) > result)) continue;
                    result = r;
                }
                break;
            }
            case 2: {
                for (int i = offset; i < end; ++i) {
                    float r;
                    int idx = (index.get(i) & 0xFFFF) * vertexSize + posoff;
                    this.tmpV.set(verts.get(idx), verts.get(idx + 1), 0.0f);
                    if (transform != null) {
                        this.tmpV.mul(transform);
                    }
                    if (!((r = this.tmpV.sub(centerX, centerY, centerZ).len2()) > result)) continue;
                    result = r;
                }
                break;
            }
            case 3: {
                for (int i = offset; i < end; ++i) {
                    float r;
                    int idx = (index.get(i) & 0xFFFF) * vertexSize + posoff;
                    this.tmpV.set(verts.get(idx), verts.get(idx + 1), verts.get(idx + 2));
                    if (transform != null) {
                        this.tmpV.mul(transform);
                    }
                    if (!((r = this.tmpV.sub(centerX, centerY, centerZ).len2()) > result)) continue;
                    result = r;
                }
                break;
            }
        }
        return result;
    }
}

