/*
 * Decompiled with CFR 0.152.
 */
package com.github.mfathi91.time;

import com.github.mfathi91.time.MyUtils;
import com.github.mfathi91.time.PersianDate;
import com.github.mfathi91.time.PersianEra;
import java.time.DateTimeException;
import java.time.chrono.AbstractChronology;
import java.time.chrono.Era;
import java.time.temporal.ChronoField;
import java.time.temporal.JulianFields;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class PersianChronology
extends AbstractChronology {
    public static final PersianChronology INSTANCE = new PersianChronology();

    private PersianChronology() {
    }

    void checkValidValue(long value, TemporalField field) {
        Objects.requireNonNull(field, "field");
        if (!(field instanceof ChronoField)) {
            throw new DateTimeException("Parameter 'field' is not supported");
        }
        ChronoField cf = (ChronoField)field;
        if (!MyUtils.isBetween(value, this.range(cf).getMinimum(), this.range(cf).getMaximum())) {
            throw new DateTimeException("Invalid value for " + field + ", valid values: " + this.range(cf));
        }
    }

    void checkDayOfYear(int year, int dayOfYear) {
        int maxDayOfYear;
        this.checkValidValue(year, ChronoField.YEAR);
        int n = maxDayOfYear = this.isLeapYear(year) ? 366 : 365;
        if (!MyUtils.isBetween(dayOfYear, 1, maxDayOfYear)) {
            throw new DateTimeException("Invalid value for dayOfYear: " + dayOfYear + " ");
        }
    }

    @Override
    public String getId() {
        return "Persian";
    }

    @Override
    public String getCalendarType() {
        return "persian";
    }

    @Override
    public PersianDate date(int prolepticYear, int month, int dayOfMonth) {
        return PersianDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public PersianDate dateYearDay(int prolepticYear, int dayOfYear) {
        this.checkDayOfYear(prolepticYear, dayOfYear);
        return PersianDate.of(prolepticYear, 1, 1).plusDays(dayOfYear - 1);
    }

    @Override
    public PersianDate dateEpochDay(long epochDay) {
        return PersianDate.ofEpochDay(epochDay);
    }

    @Override
    public PersianDate date(TemporalAccessor temporal) {
        if (temporal instanceof PersianDate) {
            return (PersianDate)temporal;
        }
        return PersianDate.ofJulianDays(JulianFields.JULIAN_DAY.getFrom(temporal));
    }

    @Override
    public boolean isLeapYear(long year) {
        this.checkValidValue(year, ChronoField.YEAR);
        return PersianDate.isLeapYear((int)year);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof PersianEra)) {
            throw new ClassCastException("Era must be PersianEra");
        }
        return yearOfEra;
    }

    @Override
    public Era eraOf(int eraValue) {
        if (eraValue == 1) {
            return PersianEra.AHS;
        }
        throw new DateTimeException("invalid Persian era");
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(PersianEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case DAY_OF_MONTH: {
                return ValueRange.of(1L, 1L, 29L, 31L);
            }
            case DAY_OF_YEAR: {
                return ValueRange.of(1L, 1L, 365L, 366L);
            }
            case ALIGNED_WEEK_OF_MONTH: {
                return ValueRange.of(1L, 5L);
            }
            case YEAR: 
            case YEAR_OF_ERA: {
                return ValueRange.of(1L, 1999L);
            }
            case ERA: {
                return ValueRange.of(1L, 1L);
            }
        }
        return field.range();
    }
}

