/*
 * Decompiled with CFR 0.152.
 */
package com.memoizrlabs.retrooptional;

import com.memoizrlabs.retrooptional.Action1;
import com.memoizrlabs.retrooptional.Function0;
import com.memoizrlabs.retrooptional.Function1;
import com.memoizrlabs.retrooptional.Optional;
import com.memoizrlabs.retrooptional.Predicate;

final class Some<T>
extends Optional<T> {
    private final T value;

    Some(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public <S> Optional<S> map(Function1<? super T, S> function) {
        return Some.of(function.apply(this.value));
    }

    @Override
    public Optional<T> filter(Predicate<? super T> predicate) {
        if (predicate.verify(this.value)) {
            return this;
        }
        return Some.empty();
    }

    @Override
    public <S> Optional<S> flatMap(Function1<? super T, Optional<S>> function) {
        return function.apply(this.value);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public void doIfPresent(Action1<T> action1) {
        action1.accept(this.value);
    }

    @Override
    public T orElse(T alternative) {
        return this.value;
    }

    @Override
    public T orElseGet(Function0<T> function) {
        return this.value;
    }

    @Override
    public <X extends Throwable> T orElseThrow(Function0<X> function) throws X {
        return this.value;
    }

    public String toString() {
        return "Some {value=" + this.value + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Some)) {
            return false;
        }
        Some some = (Some)object;
        return this.value.equals(some.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

