/*
 * Decompiled with CFR 0.152.
 */
package mehdi.sakout.fancybuttons;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import mehdi.sakout.fancybuttons.R;

public class FancyButton
extends LinearLayout {
    private Context mContext;
    private int mDefaultBackgroundColor = -16777216;
    private int mFocusBackgroundColor = 0;
    private int mDefaultTextColor = -1;
    private int mDefaultIconColor = -1;
    private int mTextPosition = 1;
    private int mDefaultTextSize = 15;
    private int mDefaultTextGravity = 17;
    private String mText = null;
    private Drawable mIconResource = null;
    private int mFontIconSize = 15;
    private String mFontIcon = null;
    private int mIconPosition = 1;
    private int mIconPaddingLeft = 10;
    private int mIconPaddingRight = 10;
    private int mIconPaddingTop = 0;
    private int mIconPaddingBottom = 0;
    private int mBorderColor = 0;
    private int mBorderWidth = 0;
    private int mRadius = 0;
    private Typeface mTextTypeFace = null;
    private Typeface mIconTypeFace = null;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 3;
    public static final int POSITION_BOTTOM = 4;
    private String mDefaultIconFont = "fontawesome.ttf";
    private String mDefaultTextFont = "robotoregular.ttf";
    private ImageView mIconView;
    private TextView mFontIconView;
    private TextView mTextView;
    private boolean mGhost = false;

    public FancyButton(Context context) {
        super(context);
        this.mContext = context;
        this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
        this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
        this.initializeFancyButton();
    }

    public FancyButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.FancyButtonsAttrs, 0, 0);
        this.initAttributsArray(attrsArray);
        attrsArray.recycle();
        this.initializeFancyButton();
    }

    private void initializeFancyButton() {
        this.initializeButtonContainer();
        this.mTextView = this.setupTextView();
        this.mIconView = this.setupIconView();
        this.mFontIconView = this.setupFontIconView();
        if (this.mIconView == null && this.mFontIconView == null && this.mTextView == null) {
            Button tempTextView = new Button(this.mContext);
            tempTextView.setText((CharSequence)"Fancy Button");
            this.addView((View)tempTextView);
        } else {
            this.removeAllViews();
            this.setupBackground();
            ArrayList<Object> views = new ArrayList<Object>();
            if (this.mIconPosition == 1 || this.mIconPosition == 3) {
                if (this.mIconView != null) {
                    views.add(this.mIconView);
                }
                if (this.mFontIconView != null) {
                    views.add(this.mFontIconView);
                }
                if (this.mTextView != null) {
                    views.add(this.mTextView);
                }
            } else {
                if (this.mTextView != null) {
                    views.add(this.mTextView);
                }
                if (this.mIconView != null) {
                    views.add(this.mIconView);
                }
                if (this.mFontIconView != null) {
                    views.add(this.mFontIconView);
                }
            }
            for (View view : views) {
                this.addView(view);
            }
        }
    }

    private TextView setupTextView() {
        if (this.mText != null) {
            TextView textView = new TextView(this.mContext);
            textView.setText((CharSequence)this.mText);
            textView.setGravity(this.mDefaultTextGravity);
            textView.setTextColor(this.mDefaultTextColor);
            textView.setTextSize((float)this.mDefaultTextSize);
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            if (!this.isInEditMode() && this.mTextTypeFace != null) {
                textView.setTypeface(this.mTextTypeFace);
            }
            return textView;
        }
        return null;
    }

    private TextView setupFontIconView() {
        if (this.mFontIcon != null) {
            TextView fontIconView = new TextView(this.mContext);
            fontIconView.setTextColor(this.mDefaultIconColor);
            LinearLayout.LayoutParams iconTextViewParams = new LinearLayout.LayoutParams(-2, -2);
            iconTextViewParams.rightMargin = this.mIconPaddingRight;
            iconTextViewParams.leftMargin = this.mIconPaddingLeft;
            iconTextViewParams.topMargin = this.mIconPaddingTop;
            iconTextViewParams.bottomMargin = this.mIconPaddingBottom;
            if (this.mTextView != null) {
                if (this.mIconPosition == 3 || this.mIconPosition == 4) {
                    iconTextViewParams.gravity = 17;
                    fontIconView.setGravity(17);
                } else {
                    fontIconView.setGravity(16);
                    iconTextViewParams.gravity = 16;
                }
            } else {
                iconTextViewParams.gravity = 17;
                fontIconView.setGravity(16);
            }
            fontIconView.setLayoutParams((ViewGroup.LayoutParams)iconTextViewParams);
            if (!this.isInEditMode()) {
                fontIconView.setTextSize((float)this.mFontIconSize);
                fontIconView.setText((CharSequence)this.mFontIcon);
                fontIconView.setTypeface(this.mIconTypeFace);
            } else {
                fontIconView.setText((CharSequence)"O");
            }
            return fontIconView;
        }
        return null;
    }

    private ImageView setupIconView() {
        if (this.mIconResource != null) {
            ImageView iconView = new ImageView(this.mContext);
            iconView.setImageDrawable(this.mIconResource);
            iconView.setPadding(this.mIconPaddingLeft, this.mIconPaddingTop, this.mIconPaddingRight, this.mIconPaddingBottom);
            LinearLayout.LayoutParams iconViewParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.mTextView != null) {
                iconViewParams.gravity = this.mIconPosition == 3 || this.mIconPosition == 4 ? 17 : 0x800003;
                iconViewParams.rightMargin = 10;
                iconViewParams.leftMargin = 10;
            } else {
                iconViewParams.gravity = 16;
            }
            iconView.setLayoutParams((ViewGroup.LayoutParams)iconViewParams);
            return iconView;
        }
        return null;
    }

    private void initAttributsArray(TypedArray attrsArray) {
        this.mDefaultBackgroundColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_defaultColor, this.mDefaultBackgroundColor);
        this.mFocusBackgroundColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_focusColor, this.mFocusBackgroundColor);
        this.mDefaultTextColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_textColor, this.mDefaultTextColor);
        this.mDefaultIconColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_iconColor, this.mDefaultTextColor);
        this.mDefaultTextSize = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_textSize, (float)this.mDefaultTextSize);
        this.mDefaultTextGravity = attrsArray.getInt(R.styleable.FancyButtonsAttrs_fb_textGravity, this.mDefaultTextGravity);
        this.mBorderColor = attrsArray.getColor(R.styleable.FancyButtonsAttrs_fb_borderColor, this.mBorderColor);
        this.mBorderWidth = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_borderWidth, (float)this.mBorderWidth);
        this.mRadius = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_radius, (float)this.mRadius);
        this.mFontIconSize = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_fontIconSize, (float)this.mFontIconSize);
        this.mIconPaddingLeft = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingLeft, (float)this.mIconPaddingLeft);
        this.mIconPaddingRight = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingRight, (float)this.mIconPaddingRight);
        this.mIconPaddingTop = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingTop, (float)this.mIconPaddingTop);
        this.mIconPaddingBottom = (int)attrsArray.getDimension(R.styleable.FancyButtonsAttrs_fb_iconPaddingBottom, (float)this.mIconPaddingBottom);
        this.mGhost = attrsArray.getBoolean(R.styleable.FancyButtonsAttrs_fb_ghost, this.mGhost);
        String text = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_text);
        this.mIconPosition = attrsArray.getInt(R.styleable.FancyButtonsAttrs_fb_iconPosition, this.mIconPosition);
        String fontIcon = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_fontIconResource);
        String iconFontFamily = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_iconFont);
        String textFontFamily = attrsArray.getString(R.styleable.FancyButtonsAttrs_fb_textFont);
        Object icon = null;
        try {
            this.mIconResource = attrsArray.getDrawable(R.styleable.FancyButtonsAttrs_fb_iconResource);
        }
        catch (Exception e) {
            this.mIconResource = null;
        }
        if (fontIcon != null) {
            this.mFontIcon = fontIcon;
        }
        if (text != null) {
            this.mText = text;
        }
        if (!this.isInEditMode()) {
            if (iconFontFamily != null) {
                try {
                    this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", iconFontFamily));
                }
                catch (Exception e) {
                    Log.e((String)"Fancy", (String)e.getMessage());
                    this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
                }
            } else {
                this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
            }
            if (textFontFamily != null) {
                try {
                    this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", textFontFamily));
                }
                catch (Exception e) {
                    this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
                }
            } else {
                this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setupBackground() {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadius((float)this.mRadius);
        if (this.mGhost) {
            drawable.setColor(this.getResources().getColor(17170445));
        } else {
            drawable.setColor(this.mDefaultBackgroundColor);
        }
        if (this.mBorderColor != 0) {
            drawable.setStroke(this.mBorderWidth, this.mBorderColor);
        }
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setCornerRadius((float)this.mRadius);
        if (this.mGhost) {
            drawable2.setColor(this.getResources().getColor(17170445));
        } else {
            drawable2.setColor(this.mFocusBackgroundColor);
        }
        if (this.mBorderColor != 0) {
            if (this.mGhost) {
                drawable2.setStroke(this.mBorderWidth, this.mFocusBackgroundColor);
            } else {
                drawable2.setStroke(this.mBorderWidth, this.mBorderColor);
            }
        }
        StateListDrawable states = new StateListDrawable();
        if (this.mFocusBackgroundColor != 0) {
            states.addState(new int[]{16842919}, (Drawable)drawable2);
            states.addState(new int[]{16842908}, (Drawable)drawable2);
        }
        states.addState(new int[0], (Drawable)drawable);
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)states);
        } else {
            this.setBackground((Drawable)states);
        }
    }

    private void initializeButtonContainer() {
        if (this.mIconPosition == 3 || this.mIconPosition == 4) {
            this.setOrientation(1);
        } else {
            this.setOrientation(0);
        }
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams(-2, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.setGravity(17);
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mIconResource == null && this.mFontIcon == null && this.getPaddingLeft() == 0 && this.getPaddingRight() == 0 && this.getPaddingTop() == 0 && this.getPaddingBottom() == 0) {
            this.setPadding(20, 20, 20, 20);
        }
    }

    public void setText(String text) {
        this.mText = text;
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setText((CharSequence)text);
        }
    }

    public void setTextColor(int color2) {
        this.mDefaultTextColor = color2;
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setTextColor(color2);
        }
    }

    public void setIconColor(int color2) {
        if (this.mFontIconView != null) {
            this.mFontIconView.setTextColor(color2);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mDefaultBackgroundColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setFocusBackgroundColor(int color2) {
        this.mFocusBackgroundColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setTextSize(int textSize) {
        this.mDefaultTextSize = textSize;
        if (this.mTextView != null) {
            this.mTextView.setTextSize((float)textSize);
        }
    }

    public void setTextGravity(int gravity) {
        this.mDefaultTextGravity = gravity;
        if (this.mTextView != null) {
            this.mTextView.setGravity(gravity);
        }
    }

    public void setIconPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mIconPaddingLeft = paddingLeft;
        this.mIconPaddingTop = paddingTop;
        this.mIconPaddingRight = paddingRight;
        this.mIconPaddingBottom = paddingBottom;
        if (this.mIconView != null) {
            this.mIconView.setPadding(this.mIconPaddingLeft, this.mIconPaddingTop, this.mIconPaddingRight, this.mIconPaddingBottom);
        }
        if (this.mFontIconView != null) {
            this.mFontIconView.setPadding(this.mIconPaddingLeft, this.mIconPaddingTop, this.mIconPaddingRight, this.mIconPaddingBottom);
        }
    }

    public void setIconResource(int drawable) {
        this.mIconResource = this.mContext.getResources().getDrawable(drawable);
        if (this.mIconView == null || this.mFontIconView != null) {
            this.mFontIconView = null;
            this.initializeFancyButton();
        } else {
            this.mIconView.setImageDrawable(this.mIconResource);
        }
    }

    public void setIconResource(String icon) {
        this.mFontIcon = icon;
        if (this.mFontIconView == null) {
            this.mIconView = null;
            this.initializeFancyButton();
        } else {
            this.mFontIconView.setText((CharSequence)icon);
        }
    }

    public void setFontIconSize(int iconSize) {
        this.mFontIconSize = iconSize;
        if (this.mFontIconView != null) {
            this.mFontIconView.setTextSize((float)iconSize);
        }
    }

    public void setIconPosition(int position) {
        this.mIconPosition = position > 0 && position < 5 ? position : 1;
        this.initializeFancyButton();
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setBorderWidth(int width) {
        this.mBorderWidth = width;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public void setCustomTextFont(String fontName) {
        try {
            this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", fontName));
        }
        catch (Exception e) {
            Log.e((String)"FancyButtons", (String)e.getMessage());
            this.mTextTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("fonts/%s", this.mDefaultTextFont));
        }
        if (this.mTextView == null) {
            this.initializeFancyButton();
        } else {
            this.mTextView.setTypeface(this.mTextTypeFace);
        }
    }

    public void setCustomIconFont(String fontName) {
        try {
            this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", fontName));
        }
        catch (Exception e) {
            Log.e((String)"FancyButtons", (String)e.getMessage());
            this.mIconTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)String.format("iconfonts/%s", this.mDefaultIconFont));
        }
        if (this.mFontIconView == null) {
            this.initializeFancyButton();
        } else {
            this.mFontIconView.setTypeface(this.mIconTypeFace);
        }
    }

    public void setGhost(boolean ghost) {
        this.mGhost = ghost;
        if (this.mIconView != null || this.mFontIconView != null || this.mTextView != null) {
            this.setupBackground();
        }
    }

    public CharSequence getText() {
        if (this.mTextView != null) {
            return this.mTextView.getText();
        }
        return "";
    }

    public TextView getTextViewObject() {
        return this.mTextView;
    }

    public TextView getIconFontObject() {
        return this.mFontIconView;
    }

    public ImageView getIconImageObject() {
        return this.mIconView;
    }
}

