/*
 * Decompiled with CFR 0.152.
 */
package com.labters.documentscanner.helpers;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;

public class MathUtils {
    public static MatOfPoint toMatOfPointInt(MatOfPoint2f mat) {
        MatOfPoint matInt = new MatOfPoint();
        mat.convertTo((Mat)matInt, 4);
        return matInt;
    }

    public static MatOfPoint2f toMatOfPointFloat(MatOfPoint mat) {
        MatOfPoint2f matFloat = new MatOfPoint2f();
        mat.convertTo((Mat)matFloat, CvType.CV_32FC2);
        return matFloat;
    }

    public static double angle(Point p1, Point p2, Point p0) {
        double dx1 = p1.x - p0.x;
        double dy1 = p1.y - p0.y;
        double dx2 = p2.x - p0.x;
        double dy2 = p2.y - p0.y;
        return (dx1 * dx2 + dy1 * dy2) / Math.sqrt((dx1 * dx1 + dy1 * dy1) * (dx2 * dx2 + dy2 * dy2) + 1.0E-10);
    }

    public static MatOfPoint2f scaleRectangle(MatOfPoint2f original, double scale) {
        List originalPoints = original.toList();
        ArrayList<Point> resultPoints = new ArrayList<Point>();
        for (Point point : originalPoints) {
            resultPoints.add(new Point(point.x * scale, point.y * scale));
        }
        MatOfPoint2f result = new MatOfPoint2f();
        result.fromList(resultPoints);
        return result;
    }
}

