/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractResourcesMojo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

public class NarResourcesMojo
extends AbstractResourcesMojo {
    private boolean resourcesCopyAOL;
    private File resourceDirectory;

    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        try {
            int copied = 0;
            File noarchDir = new File(this.resourceDirectory, "noarch");
            if (noarchDir.exists()) {
                File noarchDstDir = this.getLayout().getNoArchDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion());
                this.getLog().debug((CharSequence)("Copying noarch from " + noarchDir + " to " + noarchDstDir));
                copied += NarUtil.copyDirectoryStructure(noarchDir, noarchDstDir, null, "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
            }
            this.getLog().info((CharSequence)("Copied " + copied + " resources"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("NAR: Could not copy resources", (Exception)e);
        }
        File aolDir = new File(this.resourceDirectory, "aol");
        if (aolDir.exists()) {
            String[] aol = aolDir.list();
            for (int i = 0; i < aol.length; ++i) {
                if (this.resourcesCopyAOL && !aol[i].equals(this.getAOL().toString())) continue;
                boolean ignore = false;
                for (String exclude : FileUtils.getDefaultExcludesAsList()) {
                    if (!SelectorUtils.matchPath((String)exclude.replace('/', File.separatorChar), (String)aol[i])) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                File aolFile = new File(aolDir, aol[i]);
                this.copyResources(aolFile, aolFile.getName());
            }
        }
    }
}

