/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import java.net.MalformedURLException;
import java.net.URL;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.Tracker;

public class TrackerBuilder {
    private final String mApiUrl;
    private final int mSiteId;
    private String mTrackerName;
    private String mApplicationBaseUrl;

    public static TrackerBuilder createDefault(String apiUrl, int siteId) {
        return new TrackerBuilder(apiUrl, siteId, "Default Tracker");
    }

    public TrackerBuilder(String apiUrl, int siteId, String trackerName) {
        try {
            new URL(apiUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.mApiUrl = apiUrl;
        this.mSiteId = siteId;
        this.mTrackerName = trackerName;
    }

    public String getApiUrl() {
        return this.mApiUrl;
    }

    public int getSiteId() {
        return this.mSiteId;
    }

    public TrackerBuilder setTrackerName(String name) {
        this.mTrackerName = name;
        return this;
    }

    public String getTrackerName() {
        return this.mTrackerName;
    }

    public TrackerBuilder setApplicationBaseUrl(String domain) {
        this.mApplicationBaseUrl = domain;
        return this;
    }

    public String getApplicationBaseUrl() {
        return this.mApplicationBaseUrl;
    }

    public Tracker build(Matomo matomo) {
        if (this.mApplicationBaseUrl == null) {
            this.mApplicationBaseUrl = String.format("https://%s/", matomo.getContext().getPackageName());
        }
        return new Tracker(matomo, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackerBuilder that = (TrackerBuilder)o;
        return this.mSiteId == that.mSiteId && this.mApiUrl.equals(that.mApiUrl) && this.mTrackerName.equals(that.mTrackerName);
    }

    public int hashCode() {
        int result = this.mApiUrl.hashCode();
        result = 31 * result + this.mSiteId;
        result = 31 * result + this.mTrackerName.hashCode();
        return result;
    }
}

