/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.matomo.sdk.Tracker;
import org.matomo.sdk.dispatcher.DefaultDispatcherFactory;
import org.matomo.sdk.dispatcher.DispatcherFactory;
import org.matomo.sdk.tools.BuildInfo;
import org.matomo.sdk.tools.Checksum;
import org.matomo.sdk.tools.DeviceHelper;
import org.matomo.sdk.tools.PropertySource;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/matomo/sdk/Matomo;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "deviceHelper", "Lorg/matomo/sdk/tools/DeviceHelper;", "getDeviceHelper", "()Lorg/matomo/sdk/tools/DeviceHelper;", "dispatcherFactory", "Lorg/matomo/sdk/dispatcher/DispatcherFactory;", "getDispatcherFactory", "()Lorg/matomo/sdk/dispatcher/DispatcherFactory;", "setDispatcherFactory", "(Lorg/matomo/sdk/dispatcher/DispatcherFactory;)V", "mPreferenceMap", "", "Lorg/matomo/sdk/Tracker;", "Landroid/content/SharedPreferences;", "preferences", "getPreferences", "()Landroid/content/SharedPreferences;", "getTrackerPreferences", "tracker", "Companion", "tracker_release"})
public final class Matomo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Tracker, SharedPreferences> mPreferenceMap = new HashMap();
    @NotNull
    private final Context context;
    @NotNull
    private final SharedPreferences preferences;
    @NotNull
    private DispatcherFactory dispatcherFactory = new DefaultDispatcherFactory();
    @NotNull
    private static final String LOGGER_PREFIX = "MATOMO:";
    @NotNull
    private static final String BASE_PREFERENCE_FILE = "org.matomo.sdk";
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static volatile Matomo sInstance;

    private Matomo(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.context = context2;
        SharedPreferences sharedPreferences = context.getSharedPreferences(BASE_PREFERENCE_FILE, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.preferences = sharedPreferences;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final SharedPreferences getPreferences() {
        return this.preferences;
    }

    @NotNull
    public final DispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public final void setDispatcherFactory(@NotNull DispatcherFactory dispatcherFactory) {
        Intrinsics.checkNotNullParameter((Object)dispatcherFactory, (String)"<set-?>");
        this.dispatcherFactory = dispatcherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SharedPreferences getTrackerPreferences(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Map<Tracker, SharedPreferences> map = this.mPreferenceMap;
        synchronized (map) {
            boolean bl = false;
            SharedPreferences newPrefs = this.mPreferenceMap.get(tracker);
            if (newPrefs == null) {
                String string;
                try {
                    string = "org.matomo.sdk_" + Checksum.getMD5Checksum(tracker.getName());
                }
                catch (Exception e) {
                    Timber.Forest.e((Throwable)e);
                    string = "org.matomo.sdk_" + tracker.getName();
                }
                String prefName = string;
                newPrefs = this.context.getSharedPreferences(prefName, 0);
                this.mPreferenceMap.put(tracker, newPrefs);
            }
            SharedPreferences sharedPreferences = newPrefs;
            return sharedPreferences;
        }
    }

    @NotNull
    public final DeviceHelper getDeviceHelper() {
        return new DeviceHelper(this.context, new PropertySource(), new BuildInfo());
    }

    @JvmStatic
    @Nullable
    public static final synchronized Matomo getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    @JvmStatic
    @NotNull
    public static final String tag(Class<?> ... classes) {
        return Companion.tag(classes);
    }

    @JvmStatic
    @NotNull
    public static final String tag(String ... tags) {
        return Companion.tag(tags);
    }

    public /* synthetic */ Matomo(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J)\u0010\u000b\u001a\u00020\u00042\u001a\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\"\u0006\u0012\u0002\b\u00030\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u000b\u001a\u00020\u00042\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\r\"\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/matomo/sdk/Matomo$Companion;", "", "()V", "BASE_PREFERENCE_FILE", "", "LOGGER_PREFIX", "sInstance", "Lorg/matomo/sdk/Matomo;", "getInstance", "context", "Landroid/content/Context;", "tag", "classes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)Ljava/lang/String;", "tags", "([Ljava/lang/String;)Ljava/lang/String;", "tracker_release"})
    @SourceDebugExtension(value={"SMAP\nMatomo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matomo.kt\norg/matomo/sdk/Matomo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final synchronized Matomo getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (sInstance == null) {
                Class<Matomo> clazz = Matomo.class;
                synchronized (clazz) {
                    boolean bl = false;
                    if (sInstance == null) {
                        sInstance = new Matomo(context, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return sInstance;
        }

        @JvmStatic
        @NotNull
        public final String tag(Class<?> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            String[] tags = new String[classes.length];
            int n = classes.length;
            for (int i = 0; i < n; ++i) {
                tags[i] = classes[i].getSimpleName();
            }
            return this.tag(Arrays.copyOf(tags, tags.length));
        }

        @JvmStatic
        @NotNull
        public final String tag(String ... tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            StringBuilder sb = new StringBuilder(Matomo.LOGGER_PREFIX);
            int n = tags.length;
            for (int i = 0; i < n; ++i) {
                sb.append(tags[i]);
                if (i >= tags.length - 1) continue;
                sb.append(":");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

