/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.tools;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.util.Locale;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.tools.BuildInfo;
import org.matomo.sdk.tools.PropertySource;
import timber.log.Timber;

public class DeviceHelper {
    private static final String TAG = Matomo.tag(DeviceHelper.class);
    private final Context mContext;
    private final PropertySource mPropertySource;
    private final BuildInfo mBuildInfo;

    public DeviceHelper(Context context, PropertySource propertySource, BuildInfo buildInfo) {
        this.mContext = context;
        this.mPropertySource = propertySource;
        this.mBuildInfo = buildInfo;
    }

    public String getUserLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getUserAgent() {
        String httpAgent = this.mPropertySource.getHttpAgent();
        if (httpAgent == null || httpAgent.startsWith("Apache-HttpClient/UNAVAILABLE (java")) {
            String dalvik = this.mPropertySource.getJVMVersion();
            if (dalvik == null) {
                dalvik = "0.0.0";
            }
            String android = this.mBuildInfo.getRelease();
            String model = this.mBuildInfo.getModel();
            String build = this.mBuildInfo.getBuildId();
            httpAgent = String.format(Locale.US, "Dalvik/%s (Linux; U; Android %s; %s Build/%s)", dalvik, android, model, build);
        }
        return httpAgent;
    }

    public int[] getResolution() {
        Display display;
        try {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            display = wm.getDefaultDisplay();
        }
        catch (NullPointerException e) {
            Timber.tag((String)TAG).e((Throwable)e, "Window service was not available from this context", new Object[0]);
            return null;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getRealMetrics(displayMetrics);
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        if (width == -1 || height == -1) {
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            width = dm.widthPixels;
            height = dm.heightPixels;
        }
        return new int[]{width, height};
    }
}

