/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.CharacterSet;
import com.github.marschall.memoryfilesystem.GlobPathMatcher;
import com.github.marschall.memoryfilesystem.Root;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

abstract class PathParser {
    static final String[] EMPTY = new String[0];
    final char separator;
    private final CharacterSet forbiddenCharacters;

    PathParser(String separator, CharacterSet forbiddenCharacters) {
        this.forbiddenCharacters = forbiddenCharacters;
        if (separator.length() != 1) {
            throw new IllegalArgumentException("separator must have length 1 but was \"" + separator + "\"");
        }
        this.separator = separator.charAt(0);
    }

    void check(char c) {
        if (this.forbiddenCharacters.contains(c)) {
            throw new InvalidPathException(Character.toString(c), "contains a not allowed character");
        }
    }

    void check(List<String> elements) {
        for (String element : elements) {
            if (!this.forbiddenCharacters.containsAny(element)) continue;
            throw new InvalidPathException(element, "contains a not allowed character");
        }
    }

    boolean startWithSeparator(String s) {
        char first = s.charAt(0);
        return first == '/' || first == this.separator;
    }

    abstract AbstractPath parse(Map<String, Root> var1, String var2, String ... var3);

    abstract AbstractPath parseUri(Map<String, Root> var1, String var2);

    boolean startWithSeparator(String first, String ... more) {
        if (!first.isEmpty()) {
            return this.startWithSeparator(first);
        }
        if (more != null && more.length > 0) {
            for (String s : more) {
                if (s.isEmpty()) continue;
                return this.startWithSeparator(s);
            }
        }
        return false;
    }

    abstract PathMatcher parseGlob(String var1);

    static List<GlobPathMatcher.GlobMatch> convertToMatches(List<String> elements) {
        ArrayList<GlobPathMatcher.GlobMatch> matches = new ArrayList<GlobPathMatcher.GlobMatch>(elements.size());
        for (String element : elements) {
            matches.add(PathParser.convertToMatch(element));
        }
        return matches;
    }

    private static GlobPathMatcher.GlobMatch convertToMatch(String element) {
        if (element.equals("**")) {
            return FlexibleMatch.INSTANCE;
        }
        Stream stream = new Stream(element);
        StringBuilder buffer = new StringBuilder();
        PathParser.parseGeneric(stream, buffer, ExitHandler.EMPTY, element);
        Pattern pattern = Pattern.compile(buffer.toString(), 66);
        return new PatternMatch(pattern);
    }

    private static char parseGeneric(Stream stream, StringBuilder buffer, ExitHandler exitHandler, String element) {
        block7: while (stream.hasNext()) {
            char next = stream.next();
            if (exitHandler.isExit(next)) {
                return next;
            }
            switch (next) {
                case '*': {
                    buffer.append(".*");
                    continue block7;
                }
                case '?': {
                    buffer.append('.');
                    continue block7;
                }
                case '[': {
                    PathParser.parseRange(stream, buffer, element);
                    continue block7;
                }
                case '{': {
                    PathParser.parseGroup(stream, buffer, element);
                    continue block7;
                }
                case '\\': {
                    if (!stream.hasNext()) {
                        throw new PatternSyntaxException("\\must be followed by content", element, element.length() - 1);
                    }
                    buffer.append('\\').append(stream.next());
                    continue block7;
                }
            }
            PathParser.appendSafe(next, buffer);
        }
        return exitHandler.endOfStream(element);
    }

    private static void appendSafe(char c, StringBuilder buffer) {
        if (c == '^' || c == '$' || c == '.') {
            buffer.append('\\');
        }
        buffer.append(c);
    }

    private static void parseGroup(Stream stream, StringBuilder buffer, String element) {
        ArrayList<String> groups = new ArrayList<String>(4);
        StringBuilder groupBuffer = new StringBuilder();
        while (PathParser.parseGeneric(stream, groupBuffer, ExitHandler.GROUP, element) != '}') {
            groups.add(groupBuffer.toString());
            groupBuffer = new StringBuilder(groupBuffer.length());
        }
        groups.add(groupBuffer.toString());
        boolean first = true;
        buffer.append('(');
        for (String group : groups) {
            if (!first) {
                buffer.append('|');
            } else {
                first = false;
            }
            buffer.append('(');
            buffer.append(group);
            buffer.append(')');
        }
        buffer.append(')');
    }

    private static void parseRange(Stream stream, StringBuilder buffer, String element) {
        StringBuilder rangeBuffer = new StringBuilder();
        PathParser.parseGeneric(stream, rangeBuffer, ExitHandler.RANGE, element);
        buffer.append('[');
        buffer.append((CharSequence)rangeBuffer);
        buffer.append(']');
    }

    static final class PatternMatch
    implements GlobPathMatcher.GlobMatch {
        private final Pattern pattern;

        PatternMatch(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean isFlexible() {
            return false;
        }

        @Override
        public boolean matches(String element) {
            return this.pattern.matcher(element).matches();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    static enum FlexibleMatch implements GlobPathMatcher.GlobMatch
    {
        INSTANCE;


        @Override
        public boolean isFlexible() {
            return true;
        }

        @Override
        public boolean matches(String element) {
            return true;
        }

        public String toString() {
            return "**";
        }
    }

    static final class Stream {
        private final String contents;
        private int position;

        Stream(String contents) {
            this.contents = contents;
            this.position = 0;
        }

        boolean hasNext() {
            return this.position < this.contents.length();
        }

        char next() {
            char value = this.contents.charAt(this.position);
            ++this.position;
            return value;
        }
    }

    static enum ExitHandler {
        EMPTY{

            @Override
            boolean isExit(char c) {
                return false;
            }

            @Override
            char endOfStream(String element) {
                return '\u0000';
            }
        }
        ,
        GROUP{

            @Override
            boolean isExit(char c) {
                return c == ',' || c == '}';
            }

            @Override
            char endOfStream(String element) {
                throw new PatternSyntaxException("expected }", element, element.length() - 1);
            }
        }
        ,
        RANGE{

            @Override
            boolean isExit(char c) {
                return c == ']';
            }

            @Override
            char endOfStream(String element) {
                throw new PatternSyntaxException("expected ]", element, element.length() - 1);
            }
        };


        abstract boolean isExit(char var1);

        abstract char endOfStream(String var1);
    }
}

