/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.FileAttributeViews;
import com.github.marschall.memoryfilesystem.MemoryFileSystemProperties;
import com.github.marschall.memoryfilesystem.StringTransformer;
import com.github.marschall.memoryfilesystem.StringTransformers;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class MemoryFileSystemBuilder {
    private final List<String> roots;
    private final Set<String> users;
    private final Set<String> groups;
    private final Set<Character> forbiddenCharacters;
    private final Set<String> additionalFileAttributeViews;
    private Set<PosixFilePermission> umask = Collections.emptySet();
    private String separator;
    private String currentWorkingDirectory;
    private StringTransformer storeTransformer;
    private StringTransformer lookUpTransformer;
    private StringTransformer principalTransformer;
    private Collator collator;
    private Locale locale;

    private MemoryFileSystemBuilder() {
        this.roots = new ArrayList<String>();
        this.users = new LinkedHashSet<String>();
        this.groups = new LinkedHashSet<String>();
        this.additionalFileAttributeViews = new HashSet<String>();
        this.forbiddenCharacters = new HashSet<Character>();
    }

    public MemoryFileSystemBuilder addRoot(String root) {
        this.roots.add(root);
        return this;
    }

    public MemoryFileSystemBuilder setSeprator(String separator) {
        this.separator = separator;
        return this;
    }

    public MemoryFileSystemBuilder addForbiddenCharacter(char c) {
        this.forbiddenCharacters.add(Character.valueOf(c));
        return this;
    }

    public MemoryFileSystemBuilder addUser(String userName) {
        this.users.add(userName);
        this.addGroup(userName);
        return this;
    }

    public MemoryFileSystemBuilder setUmask(Set<PosixFilePermission> umask) {
        this.umask = umask;
        return this;
    }

    public MemoryFileSystemBuilder addGroup(String groupName) {
        this.groups.add(groupName);
        return this;
    }

    public MemoryFileSystemBuilder addFileAttributeView(String fileAttributeViewName) {
        if (FileAttributeViews.isSupported(fileAttributeViewName)) {
            if (!"basic".equals(fileAttributeViewName)) {
                this.additionalFileAttributeViews.add(fileAttributeViewName);
            }
        } else {
            throw new IllegalArgumentException("file attribute view \"" + fileAttributeViewName + "\" is not supported");
        }
        return this;
    }

    public MemoryFileSystemBuilder addFileAttributeView(Class<? extends FileAttributeView> fileAttributeView) {
        return this.addFileAttributeView(FileAttributeViews.mapAttributeView(fileAttributeView));
    }

    public MemoryFileSystemBuilder setCurrentWorkingDirectory(String currentWorkingDirectory) {
        this.currentWorkingDirectory = currentWorkingDirectory;
        return this;
    }

    public MemoryFileSystemBuilder setStoreTransformer(StringTransformer storeTransformer) {
        this.storeTransformer = storeTransformer;
        return this;
    }

    public MemoryFileSystemBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public MemoryFileSystemBuilder setCaseSensitive(boolean caseSensitive) {
        if (caseSensitive) {
            this.lookUpTransformer = StringTransformers.IDENTIY;
            this.collator = MemoryFileSystemProperties.caseSensitiveCollator(this.getLocale(), false);
        } else {
            this.lookUpTransformer = StringTransformers.caseInsensitive(this.getLocale());
            this.collator = MemoryFileSystemProperties.caseInsensitiveCollator(this.getLocale());
        }
        return this;
    }

    public MemoryFileSystemBuilder setLookUpTransformer(StringTransformer lookUpTransformer) {
        this.lookUpTransformer = lookUpTransformer;
        return this;
    }

    public MemoryFileSystemBuilder setCollator(Collator collator) {
        this.collator = collator;
        return this;
    }

    public static MemoryFileSystemBuilder newEmpty() {
        return new MemoryFileSystemBuilder();
    }

    public static MemoryFileSystemBuilder newLinux() {
        return new MemoryFileSystemBuilder().addRoot("/").setSeprator("/").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(PosixFileAttributeView.class).setCurrentWorkingDirectory("/home/" + MemoryFileSystemBuilder.getSystemUserName()).setStoreTransformer(StringTransformers.IDENTIY).setCaseSensitive(true).addForbiddenCharacter('\u0000');
    }

    public static MemoryFileSystemBuilder newMacOs() {
        MemoryFileSystemBuilder builder = new MemoryFileSystemBuilder();
        return builder.addRoot("/").setSeprator("/").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(PosixFileAttributeView.class).setCurrentWorkingDirectory("/Users/" + MemoryFileSystemBuilder.getSystemUserName()).setCollator(MemoryFileSystemProperties.caseSensitiveCollator(builder.getLocale(), true)).setLookUpTransformer(StringTransformers.caseInsensitiveMacOSJvm(builder.getLocale())).setStoreTransformer(StringTransformers.NFC).addForbiddenCharacter('\u0000');
    }

    public static MemoryFileSystemBuilder newMacOsOldJvm() {
        MemoryFileSystemBuilder builder = new MemoryFileSystemBuilder();
        return builder.addRoot("/").setSeprator("/").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(PosixFileAttributeView.class).setCurrentWorkingDirectory("/Users/" + MemoryFileSystemBuilder.getSystemUserName()).setCollator(MemoryFileSystemProperties.caseSensitiveCollator(builder.getLocale(), false)).setLookUpTransformer(StringTransformers.caseInsensitiveMacOSNative(builder.getLocale())).setStoreTransformer(StringTransformers.NFD).addForbiddenCharacter('\u0000');
    }

    public static MemoryFileSystemBuilder newWindows() {
        return new MemoryFileSystemBuilder().addRoot("C:\\").setSeprator("\\").addUser(MemoryFileSystemBuilder.getSystemUserName()).addGroup(MemoryFileSystemBuilder.getSystemUserName()).addFileAttributeView(DosFileAttributeView.class).setCurrentWorkingDirectory("C:\\Users\\" + MemoryFileSystemBuilder.getSystemUserName()).setStoreTransformer(StringTransformers.IDENTIY).setCaseSensitive(false).addForbiddenCharacter('\\').addForbiddenCharacter('/').addForbiddenCharacter(':').addForbiddenCharacter('*').addForbiddenCharacter('?').addForbiddenCharacter('\"').addForbiddenCharacter('<').addForbiddenCharacter('>').addForbiddenCharacter('|');
    }

    static String getSystemUserName() {
        return System.getProperty("user.name");
    }

    public FileSystem build(String name) throws IOException {
        Map<String, ?> env = this.buildEnvironment();
        URI uri = URI.create("memory:".concat(name));
        ClassLoader classLoader = MemoryFileSystemBuilder.class.getClassLoader();
        return FileSystems.newFileSystem(uri, env, classLoader);
    }

    public Map<String, ?> buildEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (!this.roots.isEmpty()) {
            env.put("roots", this.roots);
        }
        if (this.separator != null) {
            env.put("file.separator", this.separator);
        }
        if (this.currentWorkingDirectory != null) {
            env.put("user.dir", this.currentWorkingDirectory);
        }
        if (this.storeTransformer != null) {
            env.put("path.store.transformer", this.storeTransformer);
        }
        if (this.lookUpTransformer != null) {
            env.put("path.lookup.transformer", this.lookUpTransformer);
        }
        if (this.principalTransformer != null) {
            env.put("princial.transformer", this.principalTransformer);
        }
        if (this.collator != null) {
            env.put("collator", this.collator);
        }
        if (this.additionalFileAttributeViews != null) {
            env.put("file.attrs", this.additionalFileAttributeViews);
        }
        if (this.umask != null) {
            env.put("file.umask", this.umask);
        }
        if (this.forbiddenCharacters != null) {
            env.put("file.name.forbidden", this.forbiddenCharacters);
        }
        if (!this.users.isEmpty()) {
            env.put("users", new ArrayList<String>(this.users));
        }
        if (!this.groups.isEmpty()) {
            env.put("groups", new ArrayList<String>(this.groups));
        }
        return env;
    }
}

