/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.Root;
import java.nio.file.Path;
import java.util.Map;

abstract class PathParser {
    final char separator;

    PathParser(String separator) {
        if (separator.length() != 1) {
            throw new IllegalArgumentException("separator must have length 1 but was \"" + separator + "\"");
        }
        this.separator = separator.charAt(0);
    }

    boolean startWithSeparator(String s) {
        return s.charAt(0) == '/' || s.charAt(0) == this.separator;
    }

    abstract Path parse(Map<String, Root> var1, String var2, String ... var3);

    boolean startWithSeparator(String first, String ... more) {
        if (!first.isEmpty()) {
            return this.startWithSeparator(first);
        }
        if (more != null && more.length > 0) {
            for (String s : more) {
                if (s.isEmpty()) continue;
                return this.startWithSeparator(s);
            }
        }
        return false;
    }
}

