/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.InitializingFileAttributeView;
import com.github.marschall.memoryfilesystem.MemoryEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.util.Collections;
import java.util.Set;

class MemorySymbolicLink
extends MemoryEntry {
    private final Path target;
    private final BasicFileAttributes attributes;
    private final InitializingFileAttributeView basicFileAttributeView;

    MemorySymbolicLink(String originalName, AbstractPath target) {
        this(originalName, target, Collections.emptySet());
    }

    MemorySymbolicLink(String originalName, AbstractPath target, Set<Class<? extends FileAttributeView>> additionalViews) {
        super(originalName, additionalViews);
        this.target = target;
        this.attributes = new MemorySymbolicLinkAttributes();
        this.basicFileAttributeView = new MemorySymbolicLinkAttributesView();
    }

    Path getTarget() {
        return this.target;
    }

    @Override
    InitializingFileAttributeView getBasicFileAttributeView() {
        return this.basicFileAttributeView;
    }

    @Override
    BasicFileAttributes getBasicFileAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "symlin(" + this.getOriginalName() + ") -> " + this.target;
    }

    final class MemorySymbolicLinkAttributes
    extends MemoryEntry.MemoryEntryFileAttributes {
        MemorySymbolicLinkAttributes() {
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public Object fileKey() {
            return MemorySymbolicLink.this;
        }
    }

    class MemorySymbolicLinkAttributesView
    extends MemoryEntry.MemoryEntryFileAttributesView {
        MemorySymbolicLinkAttributesView() {
        }

        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            return MemorySymbolicLink.this.attributes;
        }
    }
}

