/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.managers;

import com.google.common.base.Charsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.storage.DBCore;
import net.sacredlabyrinth.phaed.simpleclans.storage.MySQLCore;
import net.sacredlabyrinth.phaed.simpleclans.storage.SQLiteCore;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDFetcher;
import net.sacredlabyrinth.phaed.simpleclans.uuid.UUIDMigration;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class StorageManager {
    private SimpleClans plugin;
    private DBCore core;
    private HashMap<String, ChatBlock> chatBlocks = new HashMap();

    public StorageManager() {
        this.plugin = SimpleClans.getInstance();
        this.initiateDB();
        this.updateDatabase();
        this.importFromDatabase();
    }

    public ChatBlock getChatBlock(Player player) {
        if (SimpleClans.getInstance().hasUUID()) {
            return this.chatBlocks.get(player.getUniqueId().toString());
        }
        return this.chatBlocks.get(player.getName());
    }

    public void addChatBlock(CommandSender player, ChatBlock cb) {
        if (SimpleClans.getInstance().hasUUID()) {
            UUID uuid = UUIDMigration.getForcedPlayerUUID(player.getName());
            if (uuid == null) {
                return;
            }
            this.chatBlocks.put(uuid.toString(), cb);
        } else {
            this.chatBlocks.put(player.getName(), cb);
        }
    }

    public void initiateDB() {
        if (this.plugin.getSettingsManager().isUseMysql()) {
            this.core = new MySQLCore(this.plugin.getSettingsManager().getHost(), this.plugin.getSettingsManager().getDatabase(), this.plugin.getSettingsManager().getPort(), this.plugin.getSettingsManager().getUsername(), this.plugin.getSettingsManager().getPassword());
            if (this.core.checkConnection().booleanValue()) {
                String query;
                SimpleClans.log("[SimpleClans] " + this.plugin.getLang("mysql.connection.successful"), new Object[0]);
                if (!this.core.existsTable("sc_clans").booleanValue()) {
                    SimpleClans.log("Creating table: sc_clans", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_clans` ( `id` bigint(20) NOT NULL auto_increment, `verified` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `color_tag` varchar(25) NOT NULL, `name` varchar(100) NOT NULL, `friendly_fire` tinyint(1) default '0', `founded` bigint NOT NULL, `last_used` bigint NOT NULL, `packed_allies` text NOT NULL, `packed_rivals` text NOT NULL, `packed_bb` mediumtext NOT NULL, `cape_url` varchar(255) NOT NULL, `flags` text NOT NULL, `balance` double(64,2), PRIMARY KEY  (`id`), UNIQUE KEY `uq_simpleclans_1` (`tag`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_players").booleanValue()) {
                    SimpleClans.log("Creating table: sc_players", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_players` ( `id` bigint(20) NOT NULL auto_increment, `name` varchar(16) NOT NULL, `leader` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `friendly_fire` tinyint(1) default '0', `neutral_kills` int(11) default NULL, `rival_kills` int(11) default NULL, `civilian_kills` int(11) default NULL, `deaths` int(11) default NULL, `last_seen` bigint NOT NULL, `join_date` bigint NOT NULL, `trusted` tinyint(1) default '0', `flags` text NOT NULL, `packed_past_clans` text, PRIMARY KEY  (`id`), UNIQUE KEY `uq_sc_players_1` (`name`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_kills").booleanValue()) {
                    SimpleClans.log("Creating table: sc_kills", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_kills` ( `kill_id` bigint(20) NOT NULL auto_increment, `attacker` varchar(16) NOT NULL, `attacker_tag` varchar(16) NOT NULL, `victim` varchar(16) NOT NULL, `victim_tag` varchar(16) NOT NULL, `kill_type` varchar(1) NOT NULL, PRIMARY KEY  (`kill_id`));";
                    this.core.execute(query);
                }
            } else {
                SimpleClans.getInstance().getServer().getConsoleSender().sendMessage("[SimpleClans] " + ChatColor.RED + this.plugin.getLang("mysql.connection.failed"));
            }
        } else {
            this.core = new SQLiteCore(this.plugin.getDataFolder().getPath());
            if (this.core.checkConnection().booleanValue()) {
                String query;
                SimpleClans.log("[SimpleClans] " + this.plugin.getLang("sqlite.connection.successful"), new Object[0]);
                if (!this.core.existsTable("sc_clans").booleanValue()) {
                    SimpleClans.log("Creating table: sc_clans", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_clans` ( `id` bigint(20), `verified` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `color_tag` varchar(25) NOT NULL, `name` varchar(100) NOT NULL, `friendly_fire` tinyint(1) default '0', `founded` bigint NOT NULL, `last_used` bigint NOT NULL, `packed_allies` text NOT NULL, `packed_rivals` text NOT NULL, `packed_bb` mediumtext NOT NULL, `cape_url` varchar(255) NOT NULL, `flags` text NOT NULL, `balance` double(64,2) default 0.0,  PRIMARY KEY  (`id`), UNIQUE (`tag`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_players").booleanValue()) {
                    SimpleClans.log("Creating table: sc_players", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_players` ( `id` bigint(20), `name` varchar(16) NOT NULL, `leader` tinyint(1) default '0', `tag` varchar(25) NOT NULL, `friendly_fire` tinyint(1) default '0', `neutral_kills` int(11) default NULL, `rival_kills` int(11) default NULL, `civilian_kills` int(11) default NULL, `deaths` int(11) default NULL, `last_seen` bigint NOT NULL, `join_date` bigint NOT NULL, `trusted` tinyint(1) default '0', `flags` text NOT NULL, `packed_past_clans` text, PRIMARY KEY  (`id`), UNIQUE (`name`));";
                    this.core.execute(query);
                }
                if (!this.core.existsTable("sc_kills").booleanValue()) {
                    SimpleClans.log("Creating table: sc_kills", new Object[0]);
                    query = "CREATE TABLE IF NOT EXISTS `sc_kills` ( `kill_id` bigint(20), `attacker` varchar(16) NOT NULL, `attacker_tag` varchar(16) NOT NULL, `victim` varchar(16) NOT NULL, `victim_tag` varchar(16) NOT NULL, `kill_type` varchar(1) NOT NULL, PRIMARY KEY  (`kill_id`));";
                    this.core.execute(query);
                }
            } else {
                SimpleClans.getInstance().getServer().getConsoleSender().sendMessage("[SimpleClans] " + ChatColor.RED + this.plugin.getLang("sqlite.connection.failed"));
            }
        }
    }

    public void closeConnection() {
        this.core.close();
    }

    public void importFromDatabase() {
        this.plugin.getClanManager().cleanData();
        List<Clan> clans = this.retrieveClans();
        this.purgeClans(clans);
        for (Clan clan : clans) {
            this.plugin.getClanManager().importClan(clan);
        }
        for (Clan clan : clans) {
            clan.validateWarring();
        }
        if (!clans.isEmpty()) {
            SimpleClans.log(MessageFormat.format("[SimpleClans] " + this.plugin.getLang("clans"), clans.size()), new Object[0]);
        }
        List<ClanPlayer> cps = this.retrieveClanPlayers();
        this.purgeClanPlayers(cps);
        for (ClanPlayer cp : cps) {
            Clan tm = cp.getClan();
            if (tm != null) {
                tm.importMember(cp);
            }
            this.plugin.getClanManager().importClanPlayer(cp);
        }
        if (!cps.isEmpty()) {
            SimpleClans.log(MessageFormat.format("[SimpleClans] " + this.plugin.getLang("clan.players"), cps.size()), new Object[0]);
        }
    }

    public void importFromDatabaseOnePlayer(Player player) {
        this.plugin.getClanManager().deleteClanPlayerFromMemory(player.getUniqueId());
        ClanPlayer cp = this.retrieveOneClanPlayer(player.getUniqueId());
        if (cp != null) {
            Clan tm = cp.getClan();
            if (tm != null) {
                tm.importMember(cp);
            }
            this.plugin.getClanManager().importClanPlayer(cp);
            SimpleClans.log("[SimpleClans] ClanPlayer Reloaded: " + player.getName() + ", UUID: " + player.getUniqueId().toString(), new Object[0]);
        }
    }

    private void purgeClans(List<Clan> clans) {
        ArrayList<Clan> purge = new ArrayList<Clan>();
        for (Clan clan : clans) {
            if (clan.isVerified()) {
                if (clan.getInactiveDays() <= this.plugin.getSettingsManager().getPurgeClan()) continue;
                purge.add(clan);
                continue;
            }
            if (clan.getInactiveDays() <= this.plugin.getSettingsManager().getPurgeUnverified()) continue;
            purge.add(clan);
        }
        for (Clan clan : purge) {
            SimpleClans.log("[SimpleClans] " + MessageFormat.format(this.plugin.getLang("purging.clan"), clan.getName()), new Object[0]);
            this.deleteClan(clan);
            clans.remove(clan);
        }
    }

    private void purgeClanPlayers(List<ClanPlayer> cps) {
        ArrayList<ClanPlayer> purge = new ArrayList<ClanPlayer>();
        for (ClanPlayer cp : cps) {
            if (cp.getInactiveDays() <= this.plugin.getSettingsManager().getPurgePlayers() || cp.isLeader()) continue;
            purge.add(cp);
        }
        for (ClanPlayer cp : purge) {
            SimpleClans.log("[SimpleClans] " + MessageFormat.format(this.plugin.getLang("purging.player.data"), cp.getName()), new Object[0]);
            this.deleteClanPlayer(cp);
            cps.remove(cp);
        }
    }

    public List<Clan> retrieveClans() {
        ArrayList<Clan> out = new ArrayList<Clan>();
        String query = "SELECT * FROM  `sc_clans`;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        boolean verified = res.getBoolean("verified");
                        boolean friendly_fire = res.getBoolean("friendly_fire");
                        String tag = res.getString("tag");
                        String color_tag = Helper.parseColors(res.getString("color_tag"));
                        String name = res.getString("name");
                        String packed_allies = res.getString("packed_allies");
                        String packed_rivals = res.getString("packed_rivals");
                        String packed_bb = res.getString("packed_bb");
                        String cape_url = res.getString("cape_url");
                        String flags = res.getString("flags");
                        long founded = res.getLong("founded");
                        long last_used = res.getLong("last_used");
                        double balance = res.getDouble("balance");
                        if (founded == 0L) {
                            founded = new Date().getTime();
                        }
                        if (last_used == 0L) {
                            last_used = new Date().getTime();
                        }
                        Clan clan = new Clan();
                        clan.setFlags(flags);
                        clan.setVerified(verified);
                        clan.setFriendlyFire(friendly_fire);
                        clan.setTag(tag);
                        clan.setColorTag(color_tag);
                        clan.setName(name);
                        clan.setPackedAllies(packed_allies);
                        clan.setPackedRivals(packed_rivals);
                        clan.setPackedBb(packed_bb);
                        clan.setCapeUrl(cape_url);
                        clan.setFounded(founded);
                        clan.setLastUsed(last_used);
                        clan.setBalance(balance);
                        out.add(clan);
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            System.out.print(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public Clan retrieveOneClan(String tagClan) {
        Clan out = null;
        String query = "SELECT * FROM  `sc_clans` WHERE `tag` = '" + tagClan + "';";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        boolean verified = res.getBoolean("verified");
                        boolean friendly_fire = res.getBoolean("friendly_fire");
                        String tag = res.getString("tag");
                        String color_tag = Helper.parseColors(res.getString("color_tag"));
                        String name = res.getString("name");
                        String packed_allies = res.getString("packed_allies");
                        String packed_rivals = res.getString("packed_rivals");
                        String packed_bb = res.getString("packed_bb");
                        String cape_url = res.getString("cape_url");
                        String flags = res.getString("flags");
                        long founded = res.getLong("founded");
                        long last_used = res.getLong("last_used");
                        double balance = res.getDouble("balance");
                        if (founded == 0L) {
                            founded = new Date().getTime();
                        }
                        if (last_used == 0L) {
                            last_used = new Date().getTime();
                        }
                        Clan clan = new Clan();
                        clan.setFlags(flags);
                        clan.setVerified(verified);
                        clan.setFriendlyFire(friendly_fire);
                        clan.setTag(tag);
                        clan.setColorTag(color_tag);
                        clan.setName(name);
                        clan.setPackedAllies(packed_allies);
                        clan.setPackedRivals(packed_rivals);
                        clan.setPackedBb(packed_bb);
                        clan.setCapeUrl(cape_url);
                        clan.setFounded(founded);
                        clan.setLastUsed(last_used);
                        clan.setBalance(balance);
                        out = clan;
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            System.out.print(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public List<ClanPlayer> retrieveClanPlayers() {
        ArrayList<ClanPlayer> out = new ArrayList<ClanPlayer>();
        String query = "SELECT * FROM  `sc_players`;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        Clan clan;
                        String uuid = res.getString("uuid");
                        String name = res.getString("name");
                        String tag = res.getString("tag");
                        boolean leader = res.getBoolean("leader");
                        boolean friendly_fire = res.getBoolean("friendly_fire");
                        boolean trusted = res.getBoolean("trusted");
                        int neutral_kills = res.getInt("neutral_kills");
                        int rival_kills = res.getInt("rival_kills");
                        int civilian_kills = res.getInt("civilian_kills");
                        int deaths = res.getInt("deaths");
                        long last_seen = res.getLong("last_seen");
                        long join_date = res.getLong("join_date");
                        String flags = res.getString("flags");
                        String packed_past_clans = Helper.parseColors(res.getString("packed_past_clans"));
                        if (last_seen == 0L) {
                            last_seen = new Date().getTime();
                        }
                        if (join_date == 0L) {
                            join_date = new Date().getTime();
                        }
                        ClanPlayer cp = new ClanPlayer();
                        if (uuid != null) {
                            cp.setUniqueId(UUID.fromString(uuid));
                        }
                        cp.setFlags(flags);
                        cp.setName(name);
                        cp.setLeader(leader);
                        cp.setFriendlyFire(friendly_fire);
                        cp.setNeutralKills(neutral_kills);
                        cp.setRivalKills(rival_kills);
                        cp.setCivilianKills(civilian_kills);
                        cp.setDeaths(deaths);
                        cp.setLastSeen(last_seen);
                        cp.setJoinDate(join_date);
                        cp.setPackedPastClans(packed_past_clans);
                        cp.setTrusted(leader || trusted);
                        if (!tag.isEmpty() && (clan = SimpleClans.getInstance().getClanManager().getClan(tag)) != null) {
                            cp.setClan(clan);
                        }
                        out.add(cp);
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            System.out.print(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public ClanPlayer retrieveOneClanPlayer(UUID playerUniqueId) {
        ClanPlayer out = null;
        String query = "SELECT * FROM `sc_players` WHERE `uuid` = '" + playerUniqueId.toString() + "';";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String uuid = res.getString("uuid");
                        String name = res.getString("name");
                        String tag = res.getString("tag");
                        boolean leader = res.getBoolean("leader");
                        boolean friendly_fire = res.getBoolean("friendly_fire");
                        boolean trusted = res.getBoolean("trusted");
                        int neutral_kills = res.getInt("neutral_kills");
                        int rival_kills = res.getInt("rival_kills");
                        int civilian_kills = res.getInt("civilian_kills");
                        int deaths = res.getInt("deaths");
                        long last_seen = res.getLong("last_seen");
                        long join_date = res.getLong("join_date");
                        String flags = res.getString("flags");
                        String packed_past_clans = Helper.parseColors(res.getString("packed_past_clans"));
                        if (last_seen == 0L) {
                            last_seen = new Date().getTime();
                        }
                        if (join_date == 0L) {
                            join_date = new Date().getTime();
                        }
                        ClanPlayer cp = new ClanPlayer();
                        if (uuid != null) {
                            cp.setUniqueId(UUID.fromString(uuid));
                        }
                        cp.setFlags(flags);
                        cp.setName(name);
                        cp.setLeader(leader);
                        cp.setFriendlyFire(friendly_fire);
                        cp.setNeutralKills(neutral_kills);
                        cp.setRivalKills(rival_kills);
                        cp.setCivilianKills(civilian_kills);
                        cp.setDeaths(deaths);
                        cp.setLastSeen(last_seen);
                        cp.setJoinDate(join_date);
                        cp.setPackedPastClans(packed_past_clans);
                        cp.setTrusted(leader || trusted);
                        if (!tag.isEmpty()) {
                            Clan clanDB = this.retrieveOneClan(tag);
                            Clan clan = SimpleClans.getInstance().getClanManager().getClan(tag);
                            if (clan != null) {
                                Clan clanReSync = SimpleClans.getInstance().getClanManager().getClan(tag);
                                clanReSync.setFlags(clanDB.getFlags());
                                clanReSync.setVerified(clanDB.isVerified());
                                clanReSync.setFriendlyFire(clanDB.isFriendlyFire());
                                clanReSync.setTag(clanDB.getTag());
                                clanReSync.setColorTag(clanDB.getColorTag());
                                clanReSync.setName(clanDB.getName());
                                clanReSync.setPackedAllies(clanDB.getPackedAllies());
                                clanReSync.setPackedRivals(clanDB.getPackedRivals());
                                clanReSync.setPackedBb(clanDB.getPackedBb());
                                clanReSync.setCapeUrl(clanDB.getCapeUrl());
                                clanReSync.setFounded(clanDB.getFounded());
                                clanReSync.setLastUsed(clanDB.getLastUsed());
                                clanReSync.setBalance(clanDB.getBalance());
                                cp.setClan(clanReSync);
                            } else {
                                this.plugin.getClanManager().importClan(clanDB);
                                clanDB.validateWarring();
                                Clan newclan = SimpleClans.getInstance().getClanManager().getClan(clanDB.getTag());
                                cp.setClan(newclan);
                            }
                        }
                        out = cp;
                    }
                    catch (Exception ex) {
                        for (StackTraceElement el : ex.getStackTrace()) {
                            System.out.print(el.toString());
                        }
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public void insertClan(Clan clan) {
        String query = "INSERT INTO `sc_clans` (  `verified`, `tag`, `color_tag`, `name`, `friendly_fire`, `founded`, `last_used`, `packed_allies`, `packed_rivals`, `packed_bb`, `cape_url`, `flags`, `balance`) ";
        String values = "VALUES ( " + (clan.isVerified() ? 1 : 0) + ",'" + Helper.escapeQuotes(clan.getTag()) + "','" + Helper.escapeQuotes(clan.getColorTag()) + "','" + Helper.escapeQuotes(clan.getName()) + "'," + (clan.isFriendlyFire() ? 1 : 0) + ",'" + clan.getFounded() + "','" + clan.getLastUsed() + "','" + Helper.escapeQuotes(clan.getPackedAllies()) + "','" + Helper.escapeQuotes(clan.getPackedRivals()) + "','" + Helper.escapeQuotes(clan.getPackedBb()) + "','" + Helper.escapeQuotes(clan.getCapeUrl()) + "','" + Helper.escapeQuotes(clan.getFlags()) + "','" + Helper.escapeQuotes(String.valueOf(clan.getBalance())) + "');";
        this.core.insert(query + values);
    }

    public void updateClanAsync(final Clan clan) {
        this.plugin.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                StorageManager.this.updateClan(clan);
            }
        });
    }

    public void updatePlayerNameAsync(final Player p) {
        this.plugin.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                StorageManager.this.updatePlayerName(p);
            }
        });
    }

    public void updatePlayerName(Player p) {
        String query = "UPDATE `sc_players` SET `name` = '" + p.getName() + "' WHERE uuid = '" + p.getUniqueId().toString() + "';";
        this.core.update(query);
    }

    public void updateClan(Clan clan) {
        clan.updateLastUsed();
        String query = "UPDATE `sc_clans` SET verified = " + (clan.isVerified() ? 1 : 0) + ", tag = '" + Helper.escapeQuotes(clan.getTag()) + "', color_tag = '" + Helper.escapeQuotes(clan.getColorTag()) + "', name = '" + Helper.escapeQuotes(clan.getName()) + "', friendly_fire = " + (clan.isFriendlyFire() ? 1 : 0) + ", founded = '" + clan.getFounded() + "', last_used = '" + clan.getLastUsed() + "', packed_allies = '" + Helper.escapeQuotes(clan.getPackedAllies()) + "', packed_rivals = '" + Helper.escapeQuotes(clan.getPackedRivals()) + "', packed_bb = '" + Helper.escapeQuotes(clan.getPackedBb()) + "', cape_url = '" + Helper.escapeQuotes(clan.getCapeUrl()) + "', cape_url = '" + Helper.escapeQuotes(String.valueOf(clan.getCapeUrl())) + "', balance = '" + clan.getBalance() + "', flags = '" + Helper.escapeQuotes(clan.getFlags()) + "' WHERE tag = '" + Helper.escapeQuotes(clan.getTag()) + "';";
        this.core.update(query);
    }

    public void updateClan(Clan clan, boolean updateLastUsed) {
        if (updateLastUsed) {
            clan.updateLastUsed();
        }
        String query = "UPDATE `sc_clans` SET verified = " + (clan.isVerified() ? 1 : 0) + ", tag = '" + Helper.escapeQuotes(clan.getTag()) + "', color_tag = '" + Helper.escapeQuotes(clan.getColorTag()) + "', name = '" + Helper.escapeQuotes(clan.getName()) + "', friendly_fire = " + (clan.isFriendlyFire() ? 1 : 0) + ", founded = '" + clan.getFounded() + "', last_used = '" + clan.getLastUsed() + "', packed_allies = '" + Helper.escapeQuotes(clan.getPackedAllies()) + "', packed_rivals = '" + Helper.escapeQuotes(clan.getPackedRivals()) + "', packed_bb = '" + Helper.escapeQuotes(clan.getPackedBb()) + "', cape_url = '" + Helper.escapeQuotes(clan.getCapeUrl()) + "', cape_url = '" + Helper.escapeQuotes(String.valueOf(clan.getCapeUrl())) + "', balance = '" + clan.getBalance() + "', flags = '" + Helper.escapeQuotes(clan.getFlags()) + "' WHERE tag = '" + Helper.escapeQuotes(clan.getTag()) + "';";
        this.core.update(query);
    }

    public void deleteClan(Clan clan) {
        String query = "DELETE FROM `sc_clans` WHERE tag = '" + clan.getTag() + "';";
        this.core.delete(query);
    }

    public void insertClanPlayer(ClanPlayer cp) {
        if (SimpleClans.getInstance().hasUUID()) {
            String query = "INSERT INTO `sc_players` ( `uuid`, `name`, `leader`, `tag`, `friendly_fire`, `neutral_kills`, `rival_kills`, `civilian_kills`, `deaths`, `last_seen`, `join_date`, `packed_past_clans`, `flags`) ";
            String values = "VALUES ( '" + cp.getUniqueId().toString() + "', '" + cp.getName() + "'," + (cp.isLeader() ? 1 : 0) + ",'" + Helper.escapeQuotes(cp.getTag()) + "'," + (cp.isFriendlyFire() ? 1 : 0) + "," + cp.getNeutralKills() + "," + cp.getRivalKills() + "," + cp.getCivilianKills() + "," + cp.getDeaths() + ",'" + cp.getLastSeen() + "',' " + cp.getJoinDate() + "','" + Helper.escapeQuotes(cp.getPackedPastClans()) + "','" + Helper.escapeQuotes(cp.getFlags()) + "');";
            this.core.insert(query + values);
        } else {
            String query = "INSERT INTO `sc_players` (  `name`, `leader`, `tag`, `friendly_fire`, `neutral_kills`, `rival_kills`, `civilian_kills`, `deaths`, `last_seen`, `join_date`, `packed_past_clans`, `flags`) ";
            String values = "VALUES ( '" + cp.getName() + "'," + (cp.isLeader() ? 1 : 0) + ",'" + Helper.escapeQuotes(cp.getTag()) + "'," + (cp.isFriendlyFire() ? 1 : 0) + "," + cp.getNeutralKills() + "," + cp.getRivalKills() + "," + cp.getCivilianKills() + "," + cp.getDeaths() + ",'" + cp.getLastSeen() + "',' " + cp.getJoinDate() + "','" + Helper.escapeQuotes(cp.getPackedPastClans()) + "','" + Helper.escapeQuotes(cp.getFlags()) + "');";
            this.core.insert(query + values);
        }
    }

    public void updateClanPlayerAsync(final ClanPlayer cp) {
        this.plugin.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                StorageManager.this.updateClanPlayer(cp);
            }
        });
    }

    public void updateClanPlayer(ClanPlayer cp) {
        cp.updateLastSeen();
        if (SimpleClans.getInstance().hasUUID()) {
            String query = "UPDATE `sc_players` SET leader = " + (cp.isLeader() ? 1 : 0) + ", tag = '" + Helper.escapeQuotes(cp.getTag()) + "' , friendly_fire = " + (cp.isFriendlyFire() ? 1 : 0) + ", neutral_kills = " + cp.getNeutralKills() + ", rival_kills = " + cp.getRivalKills() + ", civilian_kills = " + cp.getCivilianKills() + ", deaths = " + cp.getDeaths() + ", last_seen = '" + cp.getLastSeen() + "', packed_past_clans = '" + Helper.escapeQuotes(cp.getPackedPastClans()) + "', trusted = " + (cp.isTrusted() ? 1 : 0) + ", flags = '" + Helper.escapeQuotes(cp.getFlags()) + "', name = '" + cp.getName() + "' WHERE `uuid` = '" + cp.getUniqueId().toString() + "';";
            this.core.update(query);
        } else {
            String query = "UPDATE `sc_players` SET leader = " + (cp.isLeader() ? 1 : 0) + ", tag = '" + Helper.escapeQuotes(cp.getTag()) + "' , friendly_fire = " + (cp.isFriendlyFire() ? 1 : 0) + ", neutral_kills = " + cp.getNeutralKills() + ", rival_kills = " + cp.getRivalKills() + ", civilian_kills = " + cp.getCivilianKills() + ", deaths = " + cp.getDeaths() + ", last_seen = '" + cp.getLastSeen() + "', packed_past_clans = '" + Helper.escapeQuotes(cp.getPackedPastClans()) + "', trusted = " + (cp.isTrusted() ? 1 : 0) + ", flags = '" + Helper.escapeQuotes(cp.getFlags()) + "' WHERE name = '" + cp.getName() + "';";
            this.core.update(query);
        }
    }

    public void deleteClanPlayer(ClanPlayer cp) {
        if (SimpleClans.getInstance().hasUUID()) {
            String query = "DELETE FROM `sc_players` WHERE uuid = '" + cp.getUniqueId() + "';";
            this.core.delete(query);
            this.deleteKills(cp.getUniqueId());
        } else {
            String query = "DELETE FROM `sc_players` WHERE name = '" + cp.getName() + "';";
            this.core.delete(query);
            this.deleteKills(cp.getName());
        }
    }

    public void insertKill(Player attacker, String attackerTag, Player victim, String victimTag, String type) {
        if (SimpleClans.getInstance().hasUUID()) {
            String query = "INSERT INTO `sc_kills` (  `attacker_uuid`, `attacker`, `attacker_tag`, `victim_uuid`, `victim`, `victim_tag`, `kill_type`) ";
            String values = "VALUES ( '" + attacker.getUniqueId() + "','" + attacker.getName() + "','" + attackerTag + "','" + victim.getUniqueId() + "','" + victim.getName() + "','" + victimTag + "','" + type + "');";
            this.core.insert(query + values);
        } else {
            String query = "INSERT INTO `sc_kills` (  `attacker`, `attacker_tag`, `victim`, `victim_tag`, `kill_type`) ";
            String values = "VALUES ( '" + attacker.getName() + "','" + attackerTag + "','" + victim.getName() + "','" + victimTag + "','" + type + "');";
            this.core.insert(query + values);
        }
    }

    @Deprecated
    public void deleteKills(String playerName) {
        String query = "DELETE FROM `sc_kills` WHERE `attacker` = '" + playerName + "'";
        this.core.delete(query);
    }

    public void deleteKills(UUID playerUniqueId) {
        String query = "DELETE FROM `sc_kills` WHERE `attacker_uuid` = '" + playerUniqueId + "'";
        this.core.delete(query);
    }

    public Map<String, Integer> getKillsPerPlayer(String playerName) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT victim, count(victim) AS kills FROM `sc_kills` WHERE attacker = '" + playerName + "' GROUP BY victim ORDER BY count(victim) DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String victim = res.getString("victim");
                        int kills = res.getInt("kills");
                        out.put(victim, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    public Map<String, Integer> getMostKilled() {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT attacker, victim, count(victim) AS kills FROM `sc_kills` GROUP BY attacker, victim ORDER BY 3 DESC;";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String attacker = res.getString("attacker");
                        String victim = res.getString("victim");
                        int kills = res.getInt("kills");
                        out.put(attacker + " " + victim, kills);
                    }
                    catch (Exception ex) {
                        SimpleClans.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                SimpleClans.getLog().severe(String.format("An Error occurred: %s", ex.getErrorCode()));
                SimpleClans.getLog().log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    private void updateDatabase() {
        String query = null;
        if (!this.core.existsColumn("sc_clans", "balance").booleanValue()) {
            query = "ALTER TABLE sc_clans ADD COLUMN `balance` double(64,2);";
            this.core.execute(query);
        }
        if (!this.core.existsColumn("sc_kills", "attacker_uuid").booleanValue()) {
            query = "ALTER TABLE sc_kills ADD attacker_uuid VARCHAR( 255 ) DEFAULT NULL;";
            this.core.execute(query);
        }
        if (!this.core.existsColumn("sc_kills", "victim_uuid").booleanValue()) {
            query = "ALTER TABLE sc_kills ADD victim_uuid VARCHAR( 255 ) DEFAULT NULL;";
            this.core.execute(query);
        }
        if (!this.core.existsColumn("sc_players", "uuid").booleanValue()) {
            query = "ALTER TABLE sc_players ADD uuid VARCHAR( 255 ) DEFAULT NULL;";
            this.core.execute(query);
            if (this.plugin.getSettingsManager().isUseMysql()) {
                query = "ALTER TABLE `sc_players` ADD UNIQUE `uq_player_uuid` (`uuid`);";
                this.core.execute(query);
            }
            this.updatePlayersToUUID();
            query = "ALTER TABLE sc_players DROP INDEX uq_sc_players_1;";
            this.core.execute(query);
        }
        if (this.core.existsColumn("sc_players", "uuid").booleanValue() && !this.plugin.getSettingsManager().isUseMysql()) {
            query = "CREATE UNIQUE INDEX IF NOT EXISTS `uq_player_uuid` ON `sc_players` (`uuid`);";
            this.core.execute(query);
        }
    }

    private void updatePlayersToUUID() {
        SimpleClans.log("[SimpleClans] Starting Migration to UUID Players !", new Object[0]);
        SimpleClans.log("[SimpleClans] ==================== ATTENTION DONT STOP BUKKIT ! ==================== ", new Object[0]);
        SimpleClans.log("[SimpleClans] ==================== ATTENTION DONT STOP BUKKIT ! ==================== ", new Object[0]);
        SimpleClans.log("[SimpleClans] ==================== ATTENTION DONT STOP BUKKIT ! ==================== ", new Object[0]);
        SimpleClans.getInstance().setUUID(false);
        List<ClanPlayer> cps = this.retrieveClanPlayers();
        int i = 1;
        for (ClanPlayer cp : cps) {
            try {
                UUID uuidPlayer = SimpleClans.getInstance().getServer().getOnlineMode() ? UUIDFetcher.getUUIDOfThrottled(cp.getName()) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + cp.getName()).getBytes(Charsets.UTF_8));
                String query = "UPDATE `sc_players` SET uuid = '" + uuidPlayer.toString() + "' WHERE name = '" + cp.getName() + "';";
                this.core.update(query);
                String query2 = "UPDATE `sc_kills` SET attacker_uuid = '" + uuidPlayer.toString() + "' WHERE attacker = '" + cp.getName() + "';";
                this.core.update(query2);
                String query3 = "UPDATE `sc_kills` SET victim_uuid = '" + uuidPlayer.toString() + "' WHERE victim = '" + cp.getName() + "';";
                this.core.update(query3);
                SimpleClans.log("[" + i + " / " + cps.size() + "] Success: " + cp.getName() + "; UUID: " + uuidPlayer.toString(), new Object[0]);
            }
            catch (Exception ex) {
                SimpleClans.log("[" + i + " / " + cps.size() + "] Failed [ERRO]: " + cp.getName() + "; UUID: ???", new Object[0]);
            }
            ++i;
        }
        SimpleClans.log("[SimpleClans] ==================== END OF MIGRATION ====================", new Object[0]);
        SimpleClans.log("[SimpleClans] ==================== END OF MIGRATION ====================", new Object[0]);
        SimpleClans.log("[SimpleClans] ==================== END OF MIGRATION ====================", new Object[0]);
        if (!cps.isEmpty()) {
            SimpleClans.log(MessageFormat.format("[SimpleClans] " + this.plugin.getLang("clan.players"), cps.size()), new Object[0]);
        }
        SimpleClans.getInstance().setUUID(true);
    }
}

