/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.executors;

import java.util.Set;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AllyCommandExecutor
implements CommandExecutor {
    SimpleClans plugin = SimpleClans.getInstance();

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        Player player = (Player)commandSender;
        if (!this.plugin.getSettingsManager().isAllyChatEnable()) {
            return false;
        }
        if (strings.length == 0) {
            return false;
        }
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
        if (cp == null) {
            return false;
        }
        String subCommand = strings[0];
        if (subCommand.equals(this.plugin.getLang("on"))) {
            cp.setAllyChat(true);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have enabled ally chat");
        } else if (subCommand.equals(this.plugin.getLang("off"))) {
            cp.setAllyChat(false);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have disabled ally chat");
        } else if (subCommand.equals(this.plugin.getLang("join"))) {
            cp.setChannel(ClanPlayer.Channel.ALLY);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have joined ally chat");
        } else if (subCommand.equals(this.plugin.getLang("leave"))) {
            cp.setChannel(ClanPlayer.Channel.NONE);
            this.plugin.getStorageManager().updateClanPlayer(cp);
            ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have left ally chat");
        } else if (subCommand.equals(this.plugin.getLang("mute"))) {
            if (!cp.isMutedAlly()) {
                cp.setMutedAlly(true);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have muted ally chat");
            } else {
                cp.setMutedAlly(false);
                ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + "You have unmuted ally chat");
            }
        } else {
            String code = "" + ChatColor.AQUA + ChatColor.WHITE + ChatColor.AQUA + ChatColor.BLACK;
            String message = code + this.plugin.getSettingsManager().getAllyChatBracketColor() + this.plugin.getSettingsManager().getAllyChatTagBracketLeft() + this.plugin.getSettingsManager().getAllyChatTagColor() + this.plugin.getSettingsManager().getCommandAlly() + this.plugin.getSettingsManager().getAllyChatBracketColor() + this.plugin.getSettingsManager().getAllyChatTagBracketRight() + " " + this.plugin.getSettingsManager().getAllyChatNameColor() + this.plugin.getSettingsManager().getAllyChatPlayerBracketLeft() + player.getName() + this.plugin.getSettingsManager().getAllyChatPlayerBracketRight() + " " + this.plugin.getSettingsManager().getAllyChatMessageColor() + Helper.toMessage(strings);
            SimpleClans.log(message, new Object[0]);
            Player self = cp.toPlayer();
            ChatBlock.sendMessage((CommandSender)self, message);
            Set<ClanPlayer> allies = cp.getClan().getAllAllyMembers();
            allies.addAll(cp.getClan().getMembers());
            for (ClanPlayer ally : allies) {
                if (ally.isMutedAlly()) continue;
                Player member = ally.toPlayer();
                if (SimpleClans.getInstance().hasUUID() ? player.getUniqueId().equals(ally.getUniqueId()) : player.getName().equalsIgnoreCase(ally.getName())) continue;
                ChatBlock.sendMessage((CommandSender)member, message);
            }
        }
        return false;
    }
}

