/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.executors;

import java.text.MessageFormat;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AcceptCommandExecutor
implements CommandExecutor {
    SimpleClans plugin = SimpleClans.getInstance();

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        Player player = (Player)commandSender;
        if (this.plugin.getSettingsManager().isBanned(player.getName())) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("banned"));
            return false;
        }
        ClanPlayer cp = this.plugin.getClanManager().getClanPlayer(player);
        if (cp != null) {
            Clan clan = cp.getClan();
            if (!clan.isLeader(player)) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("no.leader.permissions"));
                return false;
            }
            if (!this.plugin.getRequestManager().hasRequest(clan.getTag())) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.accept"));
                return false;
            }
            if (cp.getVote() != null) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("you.have.already.voted"));
                return false;
            }
            this.plugin.getRequestManager().accept(cp);
            clan.leaderAnnounce(ChatColor.GREEN + MessageFormat.format(this.plugin.getLang("voted.to.accept"), Helper.capitalize(player.getName())));
        } else {
            if (!this.plugin.getRequestManager().hasRequest(player.getName().toLowerCase())) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + this.plugin.getLang("nothing.to.accept"));
                return false;
            }
            if (SimpleClans.getInstance().hasUUID()) {
                cp = this.plugin.getClanManager().getCreateClanPlayer(player.getUniqueId());
                cp.setName(player.getName());
            } else {
                cp = this.plugin.getClanManager().getCreateClanPlayer(player.getName());
            }
            this.plugin.getRequestManager().accept(cp);
        }
        return true;
    }
}

