/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetRankCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        if (!plugin.getPermissionsManager().has(player, "simpleclans.leader.setrank")) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            return;
        }
        ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
        if (cp == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            return;
        }
        Clan clan = cp.getClan();
        if (!clan.isVerified()) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
            return;
        }
        if (!clan.isLeader(player)) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
            return;
        }
        if (arg.length < 1) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.setrank"), plugin.getSettingsManager().getCommandClan()));
            return;
        }
        String playerName = arg[0];
        String rank = Helper.toMessage(Helper.removeFirst(arg));
        if (!clan.isMember(playerName) && !clan.isLeader(playerName)) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.player.matched"));
            return;
        }
        ClanPlayer cpm = plugin.getClanManager().getClanPlayer(playerName);
        cpm.setRank(rank);
        plugin.getStorageManager().updateClanPlayer(cpm);
        ChatBlock.sendMessage((CommandSender)player, ChatColor.AQUA + plugin.getLang("player.rank.changed"));
    }
}

