/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.MessageFormat;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BankCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        if (!plugin.getPermissionsManager().has(player, "simpleclans.member.bank")) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            return;
        }
        ClanPlayer cp = plugin.getClanManager().getClanPlayer(player);
        double plmoney = plugin.getPermissionsManager().playerGetMoney(player);
        double money = 0.0;
        Clan clan = cp.getClan();
        if (clan == null) {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("not.a.member.of.any.clan"));
            return;
        }
        double clanbalance = clan.getBalance();
        if (clan.isMember(player)) {
            if (!clan.isVerified()) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("clan.is.not.verified"));
                return;
            }
            if (!cp.isTrusted()) {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("only.trusted.players.can.access.clan.stats"));
                return;
            }
            if (arg.length == 1) {
                if (arg[0].equalsIgnoreCase("status")) {
                    player.sendMessage(ChatColor.AQUA + MessageFormat.format("Clan-Balance: {0}", clanbalance));
                }
            } else if (arg.length == 2) {
                if (arg[1].matches("[0-9]+")) {
                    money = Double.parseDouble(arg[1]);
                }
                if (arg[0].equalsIgnoreCase("deposit")) {
                    if (!cp.getClan().isLeader(player) && !clan.isAllowDeposit()) {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
                        return;
                    }
                    if (arg[1].equalsIgnoreCase("all")) {
                        clan.deposit(plmoney, player);
                    } else {
                        clan.deposit(money, player);
                    }
                } else if (arg[0].equalsIgnoreCase("withdraw")) {
                    if (!cp.getClan().isLeader(player) && !clan.isAllowWithdraw()) {
                        ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("no.leader.permissions"));
                        return;
                    }
                    if (arg[1].equalsIgnoreCase("all")) {
                        clan.withdraw(clanbalance, player);
                    } else {
                        clan.withdraw(money, player);
                    }
                } else {
                    ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.bank"), plugin.getSettingsManager().getCommandClan()));
                }
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.bank"), plugin.getSettingsManager().getCommandClan()));
            }
        }
    }
}

