/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans;

import com.google.common.collect.ImmutableMap;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class StringSimplifier {
    public static final char DEFAULT_REPLACE_CHAR = '-';
    public static final String DEFAULT_REPLACE = String.valueOf('-');
    private static final ImmutableMap<String, String> NONDIACRITICS = ImmutableMap.builder().put((Object)".", (Object)"").put((Object)"\"", (Object)"").put((Object)"'", (Object)"").put((Object)" ", (Object)DEFAULT_REPLACE).put((Object)"]", (Object)DEFAULT_REPLACE).put((Object)"[", (Object)DEFAULT_REPLACE).put((Object)")", (Object)DEFAULT_REPLACE).put((Object)"(", (Object)DEFAULT_REPLACE).put((Object)"=", (Object)DEFAULT_REPLACE).put((Object)"!", (Object)DEFAULT_REPLACE).put((Object)"/", (Object)DEFAULT_REPLACE).put((Object)"\\", (Object)DEFAULT_REPLACE).put((Object)"&", (Object)DEFAULT_REPLACE).put((Object)",", (Object)DEFAULT_REPLACE).put((Object)"?", (Object)DEFAULT_REPLACE).put((Object)"\u00b0", (Object)DEFAULT_REPLACE).put((Object)"|", (Object)DEFAULT_REPLACE).put((Object)"<", (Object)DEFAULT_REPLACE).put((Object)">", (Object)DEFAULT_REPLACE).put((Object)";", (Object)DEFAULT_REPLACE).put((Object)":", (Object)DEFAULT_REPLACE).put((Object)"_", (Object)DEFAULT_REPLACE).put((Object)"#", (Object)DEFAULT_REPLACE).put((Object)"~", (Object)DEFAULT_REPLACE).put((Object)"+", (Object)DEFAULT_REPLACE).put((Object)"*", (Object)DEFAULT_REPLACE).put((Object)"\u0141", (Object)"l").put((Object)"\u0142", (Object)"l").put((Object)"\u00df", (Object)"ss").put((Object)"\u00e6", (Object)"ae").put((Object)"\u00f8", (Object)"o").put((Object)"\u00a9", (Object)"c").put((Object)"\u00d0", (Object)"d").put((Object)"\u00f0", (Object)"d").put((Object)"\u0110", (Object)"d").put((Object)"\u0111", (Object)"d").put((Object)"\u0189", (Object)"d").put((Object)"\u0256", (Object)"d").put((Object)"\u00de", (Object)"th").put((Object)"\u00fe", (Object)"th").build();
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    private StringSimplifier() {
    }

    public static String simplifiedString(String orig) {
        String str = orig;
        if (str == null) {
            return null;
        }
        str = StringSimplifier.stripDiacritics(str);
        if ((str = StringSimplifier.stripNonDiacritics(str)).length() == 0) {
            return orig;
        }
        return str.toLowerCase();
    }

    private static String stripNonDiacritics(String orig) {
        StringBuffer ret = new StringBuffer();
        String lastchar = null;
        for (int i = 0; i < orig.length(); ++i) {
            String toReplace;
            String source = orig.substring(i, i + 1);
            String replace = (String)NONDIACRITICS.get((Object)source);
            String string = toReplace = replace == null ? String.valueOf(source) : replace;
            if (DEFAULT_REPLACE.equals(lastchar) && DEFAULT_REPLACE.equals(toReplace)) {
                toReplace = "";
            } else {
                lastchar = toReplace;
            }
            ret.append(toReplace);
        }
        if (ret.length() > 0 && '-' == ret.charAt(ret.length() - 1)) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    private static String stripDiacritics(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }
}

