/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletResponse;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.servlet.HandleReportLoadResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.loader.ReportLoader;
import org.springframework.http.HttpStatus;

class VoidHandleReportLoadResult
extends HandleReportLoadResult<Void> {
    private final boolean isInlining;

    VoidHandleReportLoadResult(boolean inline) {
        this.isInlining = inline;
    }

    @Override
    public Void unknownReference(HttpServletResponse httpServletResponse, String referenceId) {
        BaseMapServlet.error(httpServletResponse, "Error getting print with ref=" + referenceId + ": unknown reference", HttpStatus.NOT_FOUND);
        return null;
    }

    @Override
    public Void unsupportedLoader(HttpServletResponse httpServletResponse, String referenceId) {
        BaseMapServlet.error(httpServletResponse, "Error getting print with ref=" + referenceId + " can not be loaded", HttpStatus.NOT_FOUND);
        return null;
    }

    @Override
    public Void successfulPrint(PrintJobStatus successfulPrintResult, HttpServletResponse httpServletResponse, URI reportURI, ReportLoader loader) throws IOException {
        this.sendReportFile(successfulPrintResult, httpServletResponse, loader, reportURI, this.isInlining);
        return null;
    }

    @Override
    public Void failedPrint(PrintJobStatus failedPrintJob, HttpServletResponse httpServletResponse) {
        BaseMapServlet.error(httpServletResponse, failedPrintJob.getError(), HttpStatus.INTERNAL_SERVER_ERROR);
        return null;
    }

    @Override
    public Void printJobPending(HttpServletResponse httpServletResponse, String referenceId) {
        BaseMapServlet.error(httpServletResponse, "Report has not yet completed processing", HttpStatus.ACCEPTED);
        return null;
    }
}

