/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletResponse;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.servlet.HandleReportLoadResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.loader.ReportLoader;
import org.springframework.http.HttpStatus;

class BooleanHandleReportLoadResult
extends HandleReportLoadResult<Boolean> {
    private final boolean isInlining;

    BooleanHandleReportLoadResult(boolean inline) {
        this.isInlining = inline;
    }

    @Override
    public Boolean unknownReference(HttpServletResponse httpServletResponse, String referenceId) {
        BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " unknown", HttpStatus.NOT_FOUND);
        return true;
    }

    @Override
    public Boolean unsupportedLoader(HttpServletResponse httpServletResponse, String referenceId) {
        BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " can not be loaded", HttpStatus.NOT_FOUND);
        return true;
    }

    @Override
    public Boolean successfulPrint(PrintJobStatus successfulPrintResult, HttpServletResponse httpServletResponse, URI reportURI, ReportLoader loader) throws IOException {
        this.sendReportFile(successfulPrintResult, httpServletResponse, loader, reportURI, this.isInlining);
        return true;
    }

    @Override
    public Boolean failedPrint(PrintJobStatus failedPrintJob, HttpServletResponse httpServletResponse) {
        BaseMapServlet.error(httpServletResponse, failedPrintJob.getError(), HttpStatus.INTERNAL_SERVER_ERROR);
        return true;
    }

    @Override
    public Boolean printJobPending(HttpServletResponse httpServletResponse, String referenceId) {
        return false;
    }
}

