/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.PrintException;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.AbstractMfClientHttpRequestFactoryWrapper;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.http.AbstractClientHttpRequestFactoryProcessor;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class MapUriProcessor
extends AbstractClientHttpRequestFactoryProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapUriProcessor.class);
    private final Map<Pattern, String> uriMapping = new HashMap<Pattern, String>();

    public void setMapping(Map<String, String> mapping) {
        this.uriMapping.clear();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            this.uriMapping.put(pattern, entry.getValue());
        }
    }

    @Override
    public MfClientHttpRequestFactory createFactoryWrapper(ClientHttpFactoryProcessorParam clientHttpFactoryProcessorParam, MfClientHttpRequestFactory requestFactory) {
        return new AbstractMfClientHttpRequestFactoryWrapper(requestFactory, this.matchers, false){

            @Override
            protected ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod, MfClientHttpRequestFactory requestFactory) throws IOException {
                String uriString = uri.toString();
                for (Map.Entry<Pattern, String> entry : MapUriProcessor.this.uriMapping.entrySet()) {
                    Matcher matcher = entry.getKey().matcher(uriString);
                    if (matcher.matches()) {
                        LOGGER.debug("URI {} matched {}", (Object)uriString, (Object)entry.getKey());
                        String finalUri = matcher.replaceAll(entry.getValue());
                        try {
                            return requestFactory.createRequest(new URI(finalUri), httpMethod);
                        }
                        catch (URISyntaxException e) {
                            throw new PrintException("Failed to create URI for " + finalUri, e);
                        }
                    }
                    LOGGER.debug("URI {} did not match {}", (Object)uriString, (Object)entry.getKey());
                }
                return requestFactory.createRequest(uri, httpMethod);
            }
        };
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        super.extraValidation(validationErrors, configuration);
        if (this.uriMapping.isEmpty()) {
            validationErrors.add(new IllegalArgumentException("No uri mappings were defined"));
        }
    }
}

