/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class UnhealthyCountersHealthCheck
extends HealthCheck {
    @Autowired
    private MetricRegistry metricRegistry;
    private final Set<String> unhealthyCounters = new HashSet<String>();

    protected HealthCheck.Result check() throws Exception {
        StringBuilder messageBuilder = new StringBuilder();
        boolean first = true;
        for (String unhealthyCounter : this.unhealthyCounters) {
            Counter counter;
            if (!this.metricRegistry.getNames().contains(unhealthyCounter) || (counter = this.metricRegistry.counter(unhealthyCounter)).getCount() == 0L) continue;
            if (first) {
                first = false;
            } else {
                messageBuilder.append("\n");
            }
            messageBuilder.append(unhealthyCounter);
            messageBuilder.append(" = ");
            messageBuilder.append(counter.getCount());
        }
        if (first) {
            return HealthCheck.Result.healthy((String)"No unhealthy counter found.");
        }
        return HealthCheck.Result.unhealthy((String)messageBuilder.toString());
    }

    public void recordUnhealthyCounter(String counterName) {
        this.unhealthyCounters.add(counterName);
    }

    public void recordUnhealthyProblem(String className, String description) {
        String counterName = MetricRegistry.name((String)className, (String[])new String[]{description});
        this.metricRegistry.counter(counterName).inc();
        this.recordUnhealthyCounter(counterName);
    }
}

