/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public final class JvmMetricsConfigurator {
    @Autowired
    private MetricRegistry metricRegistry;

    @PostConstruct
    public void init() {
        this.metricRegistry.register(this.name("gc"), (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register(this.name("memory"), (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register(this.name("thread-states"), (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register(this.name("fd-usage"), (Metric)new FileDescriptorRatioGauge());
    }

    private String name(String metricName) {
        return "jvm-" + metricName;
    }
}

