/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.codahale.metrics.MetricRegistry;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.HttpRequestFetcher;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.mapfish.print.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequest;

public final class WmsLayer
extends AbstractSingleImageLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmsLayer.class);
    private final WmsLayerParam params;
    private ClientHttpRequest imageRequest;

    WmsLayer(@Nonnull ExecutorService executorService, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull WmsLayerParam params, @Nonnull MetricRegistry registry, @Nonnull Configuration configuration) {
        super(executorService, styleSupplier, params, registry, configuration);
        this.params = params;
    }

    @Override
    protected BufferedImage loadImage(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext transformer) throws IOException {
        LOGGER.info("Query the WMS image {}.", (Object)this.imageRequest.getURI());
        return this.fetchImage(this.imageRequest, transformer);
    }

    public WmsLayerParam getParams() {
        return this.params;
    }

    @Override
    public boolean supportsNativeRotation() {
        return this.params.useNativeAngle && (this.params.serverType == WmsLayerParam.ServerType.MAPSERVER || this.params.serverType == WmsLayerParam.ServerType.GEOSERVER);
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromMimeType(this.params.imageFormat);
    }

    @Override
    public void prefetchResources(@Nonnull HttpRequestFetcher httpRequestFetcher, @Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext transformer, @Nonnull Processor.ExecutionContext context) {
        try {
            MapfishMapContext layerTransformer = this.getLayerTransformer(transformer);
            WmsLayerParam wmsLayerParam = this.params;
            URI commonUri = new URI(wmsLayerParam.getBaseUrl());
            Rectangle paintArea = layerTransformer.getPaintArea();
            ReferencedEnvelope envelope = layerTransformer.getBounds().toReferencedEnvelope(paintArea);
            URI uri = WmsUtilities.makeWmsGetLayerRequest(wmsLayerParam, commonUri, paintArea.getSize(), layerTransformer.getDPI(), layerTransformer.getRotation(), envelope);
            this.imageRequest = httpRequestFetcher.register(WmsUtilities.createWmsRequest(requestFactory, uri, this.params.method));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

