/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontTools.class);
    public static final Set<String> FONT_FAMILIES;

    private FontTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FontConfigDescription> listFontConfigFonts(String family) {
        ArrayList<FontConfigDescription> descriptions = new ArrayList<FontConfigDescription>();
        if (SystemUtils.IS_OS_LINUX) {
            InputStreamReader inputStreamReader = null;
            BufferedReader stdInput = null;
            try {
                String inputLine;
                String[] commands = new String[]{"fc-list", "-b", family};
                Process process = Runtime.getRuntime().exec(commands);
                inputStreamReader = new InputStreamReader(process.getInputStream(), "utf-8");
                stdInput = new BufferedReader(inputStreamReader);
                FontConfigDescription description = null;
                while ((inputLine = stdInput.readLine()) != null) {
                    if (inputLine.startsWith("Pattern ")) {
                        description = new FontConfigDescription();
                        descriptions.add(description);
                        continue;
                    }
                    if (description == null) continue;
                    FontTools.augmentFontConfigDescription(description, inputLine);
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to get font config font list", (Throwable)e);
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to close stream", (Throwable)e);
                    }
                }
                if (stdInput != null) {
                    try {
                        stdInput.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to close stream", (Throwable)e);
                    }
                }
            }
        }
        return descriptions;
    }

    private static void augmentFontConfigDescription(FontConfigDescription description, String inputLine) {
        String[] split = inputLine.trim().split(": ");
        if (split[0].equals("family")) {
            description.family = split[1].substring(1, split[1].length() - 4).split(Pattern.quote("\"(s) \""));
        } else if (split[0].equals("style")) {
            description.style = split[1].substring(1, split[1].length() - 4).split(Pattern.quote("\"(s) \""));
        } else if (split[0].equals("fullname")) {
            description.name = split[1].substring(1, split[1].length() - 4);
        } else if (split[0].equals("weight")) {
            int weight = Integer.parseInt(split[1].substring(0, split[1].length() - 6));
            description.weight = FontTools.recalculateWeight(weight);
        }
    }

    private static int recalculateWeight(int weight) {
        int result = weight < 20 ? 100 : (weight < 45 ? 200 : (weight < 65 ? 300 : (weight < 90 ? 400 : (weight < 140 ? 500 : (weight < 190 ? 600 : (weight < 203 ? 700 : (weight < 208 ? 800 : 900)))))));
        return result;
    }

    static {
        HashSet<String> ff = new HashSet<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : graphicsEnvironment.getAllFonts()) {
            ff.add(font.getFamily());
        }
        FONT_FAMILIES = Collections.unmodifiableSet(ff);
    }

    public static class FontConfigDescription {
        public String[] family;
        public String[] style;
        public String name;
        public int weight;
    }
}

