/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.wrapper.ObjectMissingException;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PElement;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;

public class PJsonArray
extends PElement
implements PArray {
    private final JSONArray array;

    public PJsonArray(PElement parent, JSONArray array, String contextName) {
        super(parent, contextName);
        this.array = array;
    }

    @Override
    public final int size() {
        return this.array.length();
    }

    @Override
    public final PObject getObject(int i) {
        return this.getJSONObject(i);
    }

    public final PJsonObject getJSONObject(int i) {
        JSONObject val = this.array.optJSONObject(i);
        String context = "[" + i + "]";
        if (val == null) {
            throw new ObjectMissingException(this, context);
        }
        return new PJsonObject(this, val, context);
    }

    @Override
    public final PArray getArray(int i) {
        return this.getJSONArray(i);
    }

    public final PJsonArray getJSONArray(int i) {
        JSONArray val = this.array.optJSONArray(i);
        String context = "[" + i + "]";
        if (val == null) {
            throw new ObjectMissingException(this, context);
        }
        return new PJsonArray(this, val, context);
    }

    @Override
    public final int getInt(int i) {
        int val = this.array.optInt(i, Integer.MIN_VALUE);
        if (val == Integer.MIN_VALUE) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
        return val;
    }

    @Override
    public final long getLong(int i) {
        long val = this.array.optLong(i, Long.MIN_VALUE);
        if (val == Long.MIN_VALUE) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
        return val;
    }

    @Override
    public final float getFloat(int i) {
        double val = this.array.optDouble(i, Double.MAX_VALUE);
        if (val == Double.MAX_VALUE) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
        return (float)val;
    }

    @Override
    public final double getDouble(int i) {
        double val = this.array.optDouble(i, Double.MAX_VALUE);
        if (val == Double.MAX_VALUE) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
        return val;
    }

    @Override
    public final String getString(int i) {
        String val = this.array.optString(i, null);
        if (val == null) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
        return val;
    }

    public final JSONArray getInternalArray() {
        return this.array;
    }

    @Override
    public final boolean getBool(int i) {
        try {
            return this.array.getBoolean(i);
        }
        catch (JSONException e) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
    }

    @Override
    public final Object get(int i) {
        try {
            return this.array.get(i);
        }
        catch (JSONException e) {
            throw new ObjectMissingException(this, "[" + i + "]");
        }
    }

    public final String toString() {
        return this.getCurrentPath() + ":\n\t" + this.array;
    }
}

