/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl.hibernate;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mapfish.print.metrics.UnhealthyCountersHealthCheck;
import org.mapfish.print.servlet.job.JobQueue;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.hibernate.PrintJobDao;
import org.mapfish.print.servlet.job.impl.hibernate.PrintJobStatusExtImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Transactional
public class HibernateJobQueue
implements JobQueue {
    private static final int DEFAULT_TIME_TO_KEEP_AFTER_ACCESS = 30;
    private static final long DEFAULT_CLEAN_UP_INTERVAL = 300L;
    private static final TimeUnit CLEAN_UP_INTERVAL_TIME_UNIT = TimeUnit.SECONDS;
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateJobQueue.class);
    @Autowired
    private PrintJobDao dao;
    @Autowired
    private PlatformTransactionManager txManager;
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired
    private UnhealthyCountersHealthCheck unhealthyCountersHealthCheck;
    private ScheduledExecutorService cleanUpTimer;
    private final long cleanupInterval = 300L;
    private int timeToKeepAfterAccessInMinutes = 30;

    public final void setTimeToKeepAfterAccessInMinutes(int timeToKeepAfterAccessInMinutes) {
        this.timeToKeepAfterAccessInMinutes = timeToKeepAfterAccessInMinutes;
    }

    @Override
    public final long getTimeToKeepAfterAccessInMillis() {
        return TimeUnit.MINUTES.toMillis(this.timeToKeepAfterAccessInMinutes);
    }

    @Override
    public final long getLastPrintCount() {
        return this.dao.count(PrintJobStatus.Status.FINISHED, PrintJobStatus.Status.CANCELED, PrintJobStatus.Status.ERROR);
    }

    @Override
    public final long getWaitingJobsCount() {
        return this.dao.count(PrintJobStatus.Status.WAITING, PrintJobStatus.Status.RUNNING);
    }

    @Override
    public final long getNumberOfRequestsMade() {
        return this.dao.count(new PrintJobStatus.Status[0]);
    }

    @Override
    public final long getAverageTimeSpentPrinting() {
        return this.dao.getTotalTimeSpentPrinting() / Math.max(1L, this.getLastPrintCount());
    }

    @Override
    @Transactional(readOnly=true)
    public long timeSinceLastStatusCheck(String referenceId) {
        Number lastCheckTime = (Number)this.dao.getValue(referenceId, "lastCheckTime");
        if (lastCheckTime == null) {
            return 0L;
        }
        return System.currentTimeMillis() - lastCheckTime.longValue();
    }

    @Override
    public final PrintJobStatus get(String referenceId, boolean external) throws NoSuchReferenceException {
        long now = System.currentTimeMillis();
        PrintJobStatusExtImpl statusRecord = this.dao.get(referenceId);
        if (statusRecord == null) {
            throw new NoSuchReferenceException(referenceId);
        }
        statusRecord.setStatusTime(now);
        if (!statusRecord.isDone() && external) {
            this.dao.updateLastCheckTime(referenceId, System.currentTimeMillis());
        }
        return statusRecord;
    }

    @Override
    public final synchronized void add(PrintJobEntry jobEntry) {
        this.dao.save(new PrintJobStatusExtImpl(jobEntry, this.getNumberOfRequestsMade()));
    }

    @Override
    public final synchronized void cancel(String referenceId, String message, boolean forceFinal) throws NoSuchReferenceException {
        PrintJobStatusExtImpl statusRecord = this.dao.get(referenceId, true);
        if (statusRecord == null) {
            throw new NoSuchReferenceException(referenceId);
        }
        if (!forceFinal && statusRecord.getStatus() == PrintJobStatus.Status.RUNNING) {
            statusRecord.setStatus(PrintJobStatus.Status.CANCELING);
        } else {
            statusRecord.setCompletionTime(System.currentTimeMillis());
            statusRecord.setStatus(PrintJobStatus.Status.CANCELED);
        }
        statusRecord.setError(message);
        this.dao.save(statusRecord);
    }

    @Override
    public final synchronized void fail(String referenceId, String message) throws NoSuchReferenceException {
        PrintJobStatusExtImpl statusRecord = this.dao.get(referenceId, true);
        if (statusRecord == null) {
            throw new NoSuchReferenceException(referenceId);
        }
        statusRecord.setCompletionTime(System.currentTimeMillis());
        statusRecord.setStatus(PrintJobStatus.Status.ERROR);
        statusRecord.setError(message);
        this.dao.save(statusRecord);
    }

    @Override
    public final synchronized void start(String referenceId) throws NoSuchReferenceException {
        PrintJobStatusExtImpl statusRecord = this.dao.get(referenceId, true);
        if (statusRecord == null) {
            throw new NoSuchReferenceException(referenceId);
        }
        statusRecord.setStatus(PrintJobStatus.Status.RUNNING);
        statusRecord.setWaitingTime(0L);
        this.dao.save(statusRecord);
    }

    @Override
    public final synchronized void done(String referenceId, PrintJobResult result) throws NoSuchReferenceException {
        PrintJobStatusExtImpl statusRecord = this.dao.get(referenceId, true);
        if (statusRecord == null) {
            throw new NoSuchReferenceException(referenceId);
        }
        statusRecord.setStatus(statusRecord.getStatus() == PrintJobStatus.Status.CANCELING ? PrintJobStatus.Status.CANCELED : PrintJobStatus.Status.FINISHED);
        statusRecord.setResult(result);
        statusRecord.setCompletionTime(System.currentTimeMillis());
        this.dao.save(statusRecord);
    }

    @Override
    public final synchronized void cancelOld(long startTimeOut, long abandonTimeout, String message) {
        long now = System.currentTimeMillis();
        this.dao.cancelOld(now - startTimeOut, now - abandonTimeout, message);
    }

    @Override
    public final synchronized List<? extends PrintJobStatus> start(int number) {
        List<PrintJobStatusExtImpl> list = this.dao.poll(number);
        for (PrintJobStatusExtImpl statusRecord : list) {
            statusRecord.setStatus(PrintJobStatus.Status.RUNNING);
            statusRecord.setWaitingTime(0L);
            this.dao.save(statusRecord);
        }
        return list;
    }

    @Override
    public final List<? extends PrintJobStatus> toCancel() {
        return this.dao.get(PrintJobStatus.Status.CANCELING);
    }

    @Override
    public void delete(String referenceId) {
        this.dao.delete(referenceId);
    }

    @PostConstruct
    public final void init() {
        this.cleanUpTimer = Executors.newScheduledThreadPool(1, timerTask -> {
            Thread thread = new Thread(timerTask, "Clean up old job records");
            thread.setDaemon(true);
            return thread;
        });
        this.cleanUpTimer.scheduleAtFixedRate(this::cleanup, 300L, 300L, CLEAN_UP_INTERVAL_TIME_UNIT);
    }

    @PreDestroy
    public final void shutdown() {
        this.cleanUpTimer.shutdownNow();
    }

    private void cleanup() {
        TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
        String name = MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"deletedOldPrintJobs"});
        try (Timer.Context deletion = this.metricRegistry.timer(name).time();){
            Integer nbDeleted = (Integer)tmpl.execute(status -> {
                try {
                    return this.dao.deleteOld(System.currentTimeMillis() - this.getTimeToKeepAfterAccessInMillis());
                }
                catch (Exception e) {
                    this.unhealthyCountersHealthCheck.recordUnhealthyProblem(name, "issue");
                    return null;
                }
            });
            if (deletion.stop() > CLEAN_UP_INTERVAL_TIME_UNIT.toNanos(300L)) {
                this.unhealthyCountersHealthCheck.recordUnhealthyProblem(name, "tooManyJobsToDeleteInInterval");
                LOGGER.warn("Deleting Old Print Jobs took longer than the scheduled interval.");
            }
            if (nbDeleted != null && nbDeleted > 0) {
                this.metricRegistry.counter(MetricRegistry.name((String)name, (String[])new String[]{"totalCount"})).inc((long)nbDeleted.intValue());
            }
        }
    }
}

