/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import java.awt.Graphics2D;
import org.mapfish.print.processor.map.scalebar.BarScalebarDrawer;
import org.mapfish.print.processor.map.scalebar.BarSubScalebarDrawer;
import org.mapfish.print.processor.map.scalebar.LineScalebarDrawer;
import org.mapfish.print.processor.map.scalebar.ScaleBarRenderSettings;
import org.mapfish.print.processor.map.scalebar.ScalebarDrawer;

public enum Type {
    LINE("line"){

        @Override
        public ScalebarDrawer createDrawer(Graphics2D graphics2d, ScaleBarRenderSettings settings) {
            return new LineScalebarDrawer(graphics2d, settings);
        }
    }
    ,
    BAR("bar"){

        @Override
        public ScalebarDrawer createDrawer(Graphics2D graphics2d, ScaleBarRenderSettings settings) {
            return new BarScalebarDrawer(graphics2d, settings);
        }
    }
    ,
    BAR_SUB("bar_sub"){

        @Override
        public ScalebarDrawer createDrawer(Graphics2D graphics2d, ScaleBarRenderSettings settings) {
            return new BarSubScalebarDrawer(graphics2d, settings);
        }
    };

    private final String label;

    private Type(String label) {
        this.label = label;
    }

    public static Type fromString(String label) {
        if (label != null) {
            for (Type type : Type.values()) {
                if (!label.equalsIgnoreCase(type.label)) continue;
                return type;
            }
        }
        return null;
    }

    public abstract ScalebarDrawer createDrawer(Graphics2D var1, ScaleBarRenderSettings var2);

    public final String getLabel() {
        return this.label;
    }
}

