/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;

public class ImagesSubReport {
    private final JasperDesign reportDesign;

    public ImagesSubReport(List<URI> graphics, Dimension size, double dpi) {
        this.reportDesign = this.createReport(graphics, size, dpi);
    }

    private JasperDesign createReport(List<URI> graphics, Dimension size, double dpi) {
        JasperDesign design = new JasperDesign();
        design.setName("map");
        design.setPageWidth(size.width);
        design.setPageHeight(size.height);
        design.setColumnWidth(size.width);
        design.setColumnSpacing(0);
        design.setLeftMargin(0);
        design.setRightMargin(0);
        design.setTopMargin(0);
        design.setBottomMargin(0);
        JRDesignBand band = new JRDesignBand();
        band.setHeight(size.height);
        this.addGraphics(graphics, band, size, design);
        design.setNoData((JRBand)band);
        design.setWhenNoDataType(WhenNoDataTypeEnum.NO_DATA_SECTION);
        design.setProperty("net.sf.jasperreports.image.dpi", String.valueOf(Math.round(dpi)));
        return design;
    }

    private void addGraphics(List<URI> graphics, JRDesignBand band, Dimension size, JasperDesign design) {
        for (URI graphicFile : graphics) {
            String fileName = new File(graphicFile).getAbsolutePath().replace('\\', '/');
            String imageExpression = "\"" + fileName + "\"";
            band.addElement(this.getImage(imageExpression, size, design));
        }
    }

    private JRDesignElement getImage(String imageExpression, Dimension mapSize, JasperDesign design) {
        JRDesignImage image = new JRDesignImage((JRDefaultStyleProvider)design);
        image.setHorizontalImageAlign(HorizontalImageAlignEnum.CENTER);
        image.setX(0);
        image.setY(0);
        image.setWidth(mapSize.width);
        image.setHeight(mapSize.height);
        image.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText(imageExpression);
        image.setExpression((JRExpression)expression);
        return image;
    }

    public final void compile(File compiledReportFile) throws JRException {
        JasperCompileManager.compileReportToFile((JasperDesign)this.reportDesign, (String)compiledReportFile.getAbsolutePath());
    }

    @VisibleForTesting
    protected final JasperDesign getReportDesign() {
        return this.reportDesign;
    }
}

