/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.collect.BiMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mapfish.print.PrintException;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.Processor;

public final class ProcessorUtils {
    private ProcessorUtils() {
    }

    public static <IN, OUT> IN populateInputParameter(Processor<IN, OUT> processor, @Nonnull Values values) {
        IN inputObject = processor.createInputParameter();
        if (inputObject != null) {
            Collection<Field> fields = ParserUtils.getAllAttributes(inputObject.getClass());
            for (Field field : fields) {
                String name = ProcessorUtils.getInputValueName(processor.getOutputPrefix(), processor.getInputMapperBiMap(), field.getName());
                Object value = values.getObject(name, Object.class);
                if (value != null) {
                    try {
                        field.set(inputObject, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new PrintException("Failed to set field of " + inputObject, e);
                    }
                }
                if (field.getAnnotation(HasDefaultValue.class) != null) continue;
                throw new NoSuchElementException(name + " is a required property for " + processor + " and therefore must be defined in the Request Data or be an output of one of the other processors. Available values: " + values.asMap().keySet() + ".");
            }
        }
        return inputObject;
    }

    public static void writeProcessorOutputToValues(Object output, Processor<?, ?> processor, Values values) {
        Object mapper = processor.getOutputMapperBiMap();
        if (mapper == null) {
            mapper = Collections.emptyMap();
        }
        Collection<Field> fields = ParserUtils.getAllAttributes(output.getClass());
        for (Field field : fields) {
            String name = ProcessorUtils.getOutputValueName(processor.getOutputPrefix(), mapper, field);
            try {
                Object value = field.get(output);
                if (value != null) {
                    values.put(name, value);
                    continue;
                }
                values.remove(name);
            }
            catch (IllegalAccessException e) {
                throw new PrintException("Failed to get field of " + output, e);
            }
        }
    }

    public static String getInputValueName(@Nullable String inputPrefix, @Nonnull BiMap<String, String> inputMapper, @Nonnull String field) {
        Object name;
        Object object = name = inputMapper == null ? null : (String)inputMapper.inverse().get((Object)field);
        if (name == null) {
            if (inputMapper != null && inputMapper.containsKey((Object)field)) {
                throw new RuntimeException("field in keys");
            }
            String[] defaultValues = new String[]{"tempTaskDirectory", "clientHttpRequestFactoryProvider", "template", "pdfConfig", "SUBREPORT_DIR", "outputFormat", "mdcContext"};
            name = inputPrefix == null || Arrays.asList(defaultValues).contains(field) ? field : inputPrefix.trim() + Character.toUpperCase(field.charAt(0)) + field.substring(1);
        }
        return name;
    }

    public static String getOutputValueName(@Nullable String outputPrefix, @Nonnull Map<String, String> outputMapper, @Nonnull Field field) {
        Object name = outputMapper.get(field.getName());
        if (name == null) {
            name = field.getName();
            if (!StringUtils.isEmpty((CharSequence)outputPrefix) && !outputPrefix.trim().isEmpty()) {
                name = outputPrefix.trim() + Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
            }
        }
        return name;
    }
}

