/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceBundleClassLoader
extends ClassLoader {
    private final File configDir;

    public ResourceBundleClassLoader(File configDir) {
        this.configDir = configDir;
    }

    @Override
    protected URL findResource(String resource) {
        try {
            return new File(this.configDir, resource).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        ByteArrayOutputStream buffer;
        try (InputStream is = super.getResourceAsStream(resource);){
            int nRead;
            if (is == null) {
                throw new IllegalArgumentException("Resource not found: " + resource);
            }
            buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(buffer.toByteArray());
    }
}

