/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.RecursiveTask;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralBounds;
import org.mapfish.print.PrintException;
import org.mapfish.print.StatsUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TilePreparationInfo;
import org.mapfish.print.map.tiled.TilePreparationTask;
import org.mapfish.print.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class CoverageTask
implements Callable<GridCoverage2D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoverageTask.class);
    private final TileCacheInformation tiledLayer;
    private final TilePreparationInfo tilePreparationInfo;
    private final boolean failOnError;
    private final MetricRegistry registry;
    private final Processor.ExecutionContext context;
    private final BufferedImage errorImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CoverageTask(@Nonnull TilePreparationInfo tilePreparationInfo, boolean failOnError, @Nonnull MetricRegistry registry, @Nonnull Processor.ExecutionContext context, @Nonnull TileCacheInformation tileCacheInfo, @Nonnull Configuration configuration) {
        this.tilePreparationInfo = tilePreparationInfo;
        this.context = context;
        this.tiledLayer = tileCacheInfo;
        this.failOnError = failOnError;
        this.registry = registry;
        Dimension tileSize = this.tiledLayer.getTileSize();
        this.errorImage = new BufferedImage(tileSize.width, tileSize.height, 6);
        Graphics2D graphics = this.errorImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor(configuration.getOpaqueTileErrorColor()));
            graphics.clearRect(0, 0, tileSize.width, tileSize.height);
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCoverage2D call() {
        try {
            BufferedImage coverageImage = this.tiledLayer.createBufferedImage(this.tilePreparationInfo.getImageWidth(), this.tilePreparationInfo.getImageHeight());
            Graphics2D graphics = coverageImage.createGraphics();
            try {
                for (TilePreparationInfo.SingleTilePreparationInfo tileInfo : this.tilePreparationInfo.getSingleTiles()) {
                    BufferedImage noBufferTileImage;
                    Tile tile = this.getTile(tileInfo);
                    if (tile.getImage() == null) continue;
                    if (this.tiledLayer.getTileBufferWidth() > 0 || this.tiledLayer.getTileBufferHeight() > 0) {
                        int noBufferWidth = Math.min(this.tiledLayer.getTileSize().width, tile.getImage().getWidth() - this.tiledLayer.getTileBufferWidth());
                        int noBufferHeight = Math.min(this.tiledLayer.getTileSize().height, tile.getImage().getHeight() - this.tiledLayer.getTileBufferHeight());
                        noBufferTileImage = tile.getImage().getSubimage(this.tiledLayer.getTileBufferWidth(), this.tiledLayer.getTileBufferHeight(), noBufferWidth, noBufferHeight);
                    } else {
                        noBufferTileImage = tile.getImage();
                    }
                    graphics.drawImage((Image)noBufferTileImage, tile.getxIndex() * this.tiledLayer.getTileSize().width, tile.getyIndex() * this.tiledLayer.getTileSize().height, null);
                }
            }
            finally {
                graphics.dispose();
            }
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
            GeneralBounds gridEnvelope = new GeneralBounds(this.tilePreparationInfo.getMapProjection());
            gridEnvelope.setEnvelope(new double[]{this.tilePreparationInfo.getGridCoverageOrigin().x, this.tilePreparationInfo.getGridCoverageOrigin().y, this.tilePreparationInfo.getGridCoverageMaxX(), this.tilePreparationInfo.getGridCoverageMaxY()});
            return factory.create((CharSequence)this.tiledLayer.createCommonUrl(), (RenderedImage)coverageImage, (Bounds)gridEnvelope, null, null, null);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new PrintException("Failed to call the coverage task", e);
        }
    }

    private Tile getTile(TilePreparationInfo.SingleTilePreparationInfo tileInfo) {
        TileTask task = tileInfo.getTileRequest() != null ? new SingleTileLoaderTask(tileInfo.getTileRequest(), this.errorImage, tileInfo.getTileIndexX(), tileInfo.getTileIndexY(), this.failOnError, this.registry, this.context) : new PlaceHolderImageTask(this.tiledLayer.getMissingTileImage(), tileInfo.getTileIndexX(), tileInfo.getTileIndexY());
        return task.call();
    }

    public static final class Tile {
        private final BufferedImage image;
        private final int xIndex;
        private final int yIndex;

        private Tile(BufferedImage image, int xIndex, int yIndex) {
            this.image = image;
            this.xIndex = xIndex;
            this.yIndex = yIndex;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getxIndex() {
            return this.xIndex;
        }

        public int getyIndex() {
            return this.yIndex;
        }
    }

    public static class PlaceHolderImageTask
    extends TileTask {
        private final BufferedImage placeholderImage;

        public PlaceHolderImageTask(BufferedImage placeholderImage, int tileOriginX, int tileOriginY) {
            super(tileOriginX, tileOriginY);
            this.placeholderImage = placeholderImage;
        }

        @Override
        protected final Tile compute() {
            return new Tile(this.placeholderImage, this.getTileIndexX(), this.getTileIndexY());
        }
    }

    public static final class SingleTileLoaderTask
    extends TileTask {
        private final ClientHttpRequest tileRequest;
        private final boolean failOnError;
        private final MetricRegistry registry;
        private final Processor.ExecutionContext context;
        private final BufferedImage errorImage;

        public SingleTileLoaderTask(ClientHttpRequest tileRequest, BufferedImage errorImage, int tileIndexX, int tileIndexY, boolean failOnError, MetricRegistry registry, Processor.ExecutionContext context) {
            super(tileIndexX, tileIndexY);
            this.tileRequest = tileRequest;
            this.errorImage = errorImage;
            this.failOnError = failOnError;
            this.registry = registry;
            this.context = context;
        }

        @Override
        protected Tile compute() {
            return this.context.mdcContext(() -> {
                String baseMetricName = TilePreparationTask.class.getName() + ".read." + StatsUtils.quotePart(this.tileRequest.getURI().getHost());
                LOGGER.debug("{} -- {}", (Object)this.tileRequest.getMethod(), (Object)this.tileRequest.getURI());
                try (Timer.Context timerDownload = this.registry.timer(baseMetricName).time();){
                    Tile tile;
                    block18: {
                        ClientHttpResponse response;
                        block16: {
                            Tile tile2;
                            block17: {
                                response = this.tileRequest.execute();
                                try {
                                    Tile x = this.handleSpecialStatuses(response, baseMetricName);
                                    if (x == null) break block16;
                                    tile2 = x;
                                    if (response == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (response != null) {
                                            try {
                                                response.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException | RuntimeException e) {
                                        this.registry.counter(baseMetricName + ".error").inc();
                                        throw new PrintException("Failed to compute Coverage Task", e);
                                    }
                                }
                                response.close();
                            }
                            return tile2;
                        }
                        BufferedImage image = this.getImageFromResponse(response, baseMetricName);
                        timerDownload.stop();
                        tile = new Tile(image, this.getTileIndexX(), this.getTileIndexY());
                        if (response == null) break block18;
                        response.close();
                    }
                    return tile;
                }
            });
        }

        private Tile handleSpecialStatuses(ClientHttpResponse response, String baseMetricName) throws IOException {
            int httpStatusCode = response.getRawStatusCode();
            if (httpStatusCode == HttpStatus.NO_CONTENT.value() || httpStatusCode == HttpStatus.NOT_FOUND.value()) {
                if (httpStatusCode == HttpStatus.NOT_FOUND.value()) {
                    LOGGER.info("The request {} returns a not found status code, we consider it as an empty tile.", (Object)this.tileRequest.getURI());
                }
                return new Tile(null, this.getTileIndexX(), this.getTileIndexY());
            }
            if (httpStatusCode != HttpStatus.OK.value()) {
                return this.handleNonOkStatus(response, baseMetricName);
            }
            return null;
        }

        private BufferedImage getImageFromResponse(ClientHttpResponse response, String baseMetricName) throws IOException {
            BufferedImage image = ImageIO.read(response.getBody());
            if (image == null) {
                LOGGER.warn("The URL: {} is an image format that cannot be decoded", (Object)this.tileRequest.getURI());
                image = this.errorImage;
                this.registry.counter(baseMetricName + ".error").inc();
            }
            return image;
        }

        private Tile handleNonOkStatus(ClientHttpResponse response, String baseMetricName) throws IOException {
            int httpStatusCode = response.getRawStatusCode();
            String errorMessage = String.format("Error making tile request: %s\n\tStatus: %d\n\tStatus message: %s", this.tileRequest.getURI(), httpStatusCode, response.getStatusText());
            LOGGER.debug(String.format("Error making tile request: %s\nStatus: %d\nStatus message: %s\nServer:%s\nBody:\n%s", this.tileRequest.getURI(), httpStatusCode, response.getStatusText(), response.getHeaders().getFirst("Server"), IOUtils.toString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8)));
            this.registry.counter(baseMetricName + ".error").inc();
            if (this.failOnError) {
                throw new RuntimeException(errorMessage);
            }
            LOGGER.info(errorMessage);
            return new Tile(this.errorImage, this.getTileIndexX(), this.getTileIndexY());
        }
    }

    public static abstract class TileTask
    extends RecursiveTask<Tile>
    implements Callable<Tile> {
        private final int tileIndexX;
        private final int tileIndexY;

        public TileTask(int tileIndexX, int tileIndexY) {
            this.tileIndexX = tileIndexX;
            this.tileIndexY = tileIndexY;
        }

        public final int getTileIndexX() {
            return this.tileIndexX;
        }

        public final int getTileIndexY() {
            return this.tileIndexY;
        }

        @Override
        public final Tile call() {
            return (Tile)this.compute();
        }
    }
}

