/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.mapfish.print.map.geotools.grid.GridLabel;

enum RotationQuadrant {
    QUADRANT_1{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(-1.5707963267948966);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(-1.5707963267948966);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.translate(indent, halfCharHeight);
                }
            }
        }
    }
    ,
    QUADRANT_2{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(-1.5707963267948966);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(-1.5707963267948966);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.rotate(Math.PI);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.rotate(Math.PI);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                }
            }
        }
    }
    ,
    QUADRANT_3{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(1.5707963267948966);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(1.5707963267948966);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.rotate(Math.PI);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.rotate(Math.PI);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                }
            }
        }
    }
    ,
    QUADRANT_4{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.rotate(1.5707963267948966);
                    baseTransform.translate(indent, halfCharHeight);
                    break;
                }
                case BOTTOM: {
                    baseTransform.rotate(1.5707963267948966);
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                case RIGHT: {
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.translate(indent, halfCharHeight);
                }
            }
        }
    }
    ,
    NO_ROTATION{

        @Override
        void updateTransform(AffineTransform baseTransform, int indent, GridLabel.Side side, int halfCharHeight, Rectangle2D textBounds) {
            switch (side) {
                case TOP: {
                    baseTransform.translate(-textBounds.getWidth() / 2.0, (double)indent + (double)halfCharHeight * 2.0);
                    break;
                }
                case BOTTOM: {
                    baseTransform.translate(-textBounds.getWidth() / 2.0, -halfCharHeight - indent);
                    break;
                }
                case RIGHT: {
                    baseTransform.translate(-textBounds.getWidth() - (double)indent, halfCharHeight);
                    break;
                }
                default: {
                    baseTransform.translate(indent, halfCharHeight);
                }
            }
        }
    };

    public static final double THREE_SIXTY_RADIANS = Math.PI * 2;

    static RotationQuadrant getQuadrant(double rotation, boolean rotate) {
        double rot;
        if (!rotate) {
            return NO_ROTATION;
        }
        for (rot = rotation; rot > Math.PI * 2; rot -= Math.PI * 2) {
        }
        while (rot < 0.0) {
            rot += Math.PI * 2;
        }
        if (rotation > 0.0 && rotation <= 1.5707963267948966) {
            return QUADRANT_1;
        }
        if (rot > 1.5707963267948966 && rot <= Math.PI) {
            return QUADRANT_2;
        }
        if (rot > Math.PI && rot <= 4.71238898038469) {
            return QUADRANT_3;
        }
        return QUADRANT_4;
    }

    abstract void updateTransform(AffineTransform var1, int var2, GridLabel.Side var3, int var4, Rectangle2D var5);

    private static class Constants {
        public static final double MINUS_NINETY_RADIANS = -1.5707963267948966;
        public static final double ONE_EIGHTY_RADIANS = Math.PI;
        public static final double NINETY_RADIANS = 1.5707963267948966;

        private Constants() {
        }
    }
}

