/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.awt.Color;
import java.util.List;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.styling.StyleBuilder;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.style.json.ColorParser;

public final class PointGridStyle {
    private static final double CROSS_SIZE = 10.0;

    private PointGridStyle() {
    }

    static Style get(GridParam params) {
        StyleBuilder builder = new StyleBuilder();
        Symbolizer pointSymbolizer = PointGridStyle.crossSymbolizer("shape://plus", builder, 10.0, params.gridColor);
        Style style = builder.createStyle(pointSymbolizer);
        List symbolizers = ((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers();
        if (params.haloRadius > 0.0) {
            Symbolizer halo = PointGridStyle.crossSymbolizer("cross", builder, 10.0 + params.haloRadius * 2.0, params.haloColor);
            symbolizers.add(0, halo);
        }
        return style;
    }

    private static Symbolizer crossSymbolizer(String name, StyleBuilder builder, double crossSize, String pointColorTxt) {
        Color pointColor = ColorParser.toColor(pointColorTxt);
        Mark cross = builder.createMark(name, pointColor, pointColor, 1.0);
        Graphic graphic = builder.createGraphic(null, cross, null);
        graphic.setSize(builder.literalExpression(crossSize));
        return builder.createPointSymbolizer(graphic);
    }
}

