/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import org.apache.http.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAgentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentCreator.class);
    private static final String AGENT_NAME = "MapFishPrint";

    private UserAgentCreator() {
    }

    public static String getUserAgent() {
        String httpClientUserAgent = VersionInfo.getUserAgent((String)"Apache-HttpClient", (String)"org.apache.http.client", UserAgentCreator.class);
        VersionInfo mapFishPrintVersionInfo = VersionInfo.loadVersionInfo((String)"org.mapfish.print", (ClassLoader)UserAgentCreator.class.getClassLoader());
        String mfpRelease = "0.0.0";
        try {
            mfpRelease = mapFishPrintVersionInfo.getRelease();
        }
        catch (Exception e) {
            LOGGER.error("Error getting MapFishPrint version", (Throwable)e);
        }
        String userAgent = String.format("%s/%s %s", AGENT_NAME, mfpRelease, httpClientUserAgent);
        return userAgent;
    }
}

