/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ReportStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ReportStorage
implements ReportStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ReportStorage.class);
    private static final long PURGE_INTERVAL_MS = 21600000L;
    private static long nextPurge = 0L;
    private String bucket = null;
    private String prefix = "";
    private String accessKey = null;
    private String secretKey = null;
    private String region = null;
    private String endpointUrl = null;
    private int retentionDays = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybePurge(AmazonS3 client) {
        boolean needPurge = false;
        Class<S3ReportStorage> clazz = S3ReportStorage.class;
        synchronized (S3ReportStorage.class) {
            if (System.currentTimeMillis() >= nextPurge) {
                needPurge = true;
                nextPurge = System.currentTimeMillis() + 21600000L;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (needPurge) {
                this.purge(client);
            }
            return;
        }
    }

    private void purge(AmazonS3 client) {
        LOGGER.debug("Checking for reports to delete");
        Date now = new Date();
        long retentionMs = TimeUnit.MILLISECONDS.convert(this.retentionDays, TimeUnit.DAYS);
        try {
            ObjectListing objects = client.listObjects(this.bucket, this.prefix);
            for (S3ObjectSummary object : objects.getObjectSummaries()) {
                Date lastModified = object.getLastModified();
                long ageMs = now.getTime() - lastModified.getTime();
                if (ageMs <= retentionMs) continue;
                LOGGER.info("Deleting old report: {}/{}", (Object)this.bucket, (Object)object.getKey());
                client.deleteObject(this.bucket, object.getKey());
            }
        }
        catch (SdkClientException ex) {
            LOGGER.warn("Error while trying the delete old reports", (Throwable)ex);
        }
    }

    private AmazonS3 connect() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (this.accessKey != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials));
        }
        if (this.endpointUrl != null) {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointUrl, this.region));
        } else if (this.region != null) {
            builder.withRegion(this.region);
        }
        return (AmazonS3)builder.build();
    }

    @Override
    public URL save(String ref, String filename, String extension, String mimeType, File file) {
        AmazonS3 client = this.connect();
        this.maybePurge(client);
        PutObjectRequest request = this.createPutRequest(ref, filename, extension, mimeType, file);
        client.putObject(request);
        URL url = client.getUrl(this.bucket, request.getKey());
        LOGGER.info("Report stored on S3: {}", (Object)url);
        return url;
    }

    private PutObjectRequest createPutRequest(String ref, String filename, String extension, String mimeType, File file) {
        PutObjectRequest request = new PutObjectRequest(this.bucket, this.getKey(ref, filename, extension), file);
        request.withCannedAcl(CannedAccessControlList.PublicRead);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(mimeType);
        request.withMetadata(metadata);
        return request;
    }

    protected String getKey(String ref, String filename, String extension) {
        return this.prefix + ref + "/" + filename + "." + extension;
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.bucket == null) {
            validationErrors.add(new ConfigurationException("You must define a bucket"));
        }
        if (this.accessKey != null && this.secretKey == null) {
            validationErrors.add(new ConfigurationException("If you define the accessKey, you must define the secretKey"));
        }
        if (!this.prefix.endsWith("/") && !this.prefix.isEmpty()) {
            this.prefix = this.prefix + "/";
        }
        if (this.retentionDays <= 0) {
            validationErrors.add(new ConfigurationException("retentionDays must be bigger that 0"));
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getRetentionDays() {
        return this.retentionDays;
    }

    public void setRetentionDays(int retentionDays) {
        this.retentionDays = retentionDays;
    }
}

