/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import java.util.List;
import javax.annotation.Nonnull;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.mapfish.print.wrapper.multi.PMultiObject;

public abstract class PrimitiveAttribute<VALUE>
implements Attribute {
    protected VALUE defaultValue;
    private Class<VALUE> valueClass;
    private String configName;

    protected PrimitiveAttribute(Class<VALUE> valueClass) {
        this.valueClass = valueClass;
    }

    public final Class<VALUE> getValueClass() {
        return this.valueClass;
    }

    public final VALUE getDefault() {
        return this.defaultValue;
    }

    public abstract void setDefault(VALUE var1);

    @Override
    public final void setConfigName(String configName) {
        this.configName = configName;
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    public void validateValue(Object value) {
    }

    @Override
    public final void printClientConfig(JSONWriter json, Template template) throws JSONException {
        json.key("name").value((Object)this.configName);
        json.key("type").value((Object)this.clientConfigTypeDescription());
        if (this.getDefault() != null) {
            json.key("default").value(this.getDefault());
        }
    }

    protected String clientConfigTypeDescription() {
        return this.valueClass.getSimpleName();
    }

    @Override
    public Object getValue(@Nonnull Template template, @Nonnull String attributeName, @Nonnull PObject requestJsonAttributes) {
        VALUE defaultVal = this.getDefault();
        PObject jsonToUse = requestJsonAttributes;
        if (defaultVal != null) {
            JSONObject obj = new JSONObject();
            obj.put(attributeName, defaultVal);
            PObject[] pValues = new PObject[]{requestJsonAttributes, new PJsonObject(obj, "default_" + attributeName)};
            jsonToUse = new PMultiObject(pValues);
        }
        return MapfishParser.parsePrimitive(attributeName, this, jsonToUse);
    }
}

