/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JsonDataSource;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.wrapper.PObject;

public class JsonDatasourceAttribute
implements Attribute {
    private String configName;

    @Override
    public void printClientConfig(JSONWriter json, Template template) throws JSONException {
        json.key("name").value((Object)this.configName);
        json.key("type").value((Object)"json");
    }

    @Override
    public void setConfigName(String name) {
        this.configName = name;
    }

    public Class getValueType() {
        return JsonDataSource.class;
    }

    @Override
    public Object getValue(@Nonnull Template template, @Nonnull String attributeName, @Nonnull PObject requestJsonAttributes) {
        String json;
        Object value = requestJsonAttributes.opt(attributeName);
        if (value == null) {
            json = "null";
        } else if (value instanceof JSONObject) {
            json = value.toString();
        } else {
            String message = "Expected a JSON Object as the value for the element with the path: '" + requestJsonAttributes.getPath(attributeName) + "' but instead got a '" + value.getClass().toString() + "'";
            throw new IllegalArgumentException(message);
        }
        try {
            JsonDataSource result = new JsonDataSource((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
            result.next();
            return result;
        }
        catch (JRException e) {
            throw new RuntimeException("Error while parsing " + requestJsonAttributes.getPath(attributeName) + " as json", e);
        }
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }
}

