/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.spark.typify.route;

import io.github.manusant.spark.typify.annotation.Json;
import io.github.manusant.spark.typify.annotation.Xml;
import io.github.manusant.spark.typify.exception.ReflectionExceptions;
import io.github.manusant.spark.typify.provider.TypifyProvider;
import io.github.manusant.spark.typify.spec.ContentType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import spark.Request;
import spark.Response;
import spark.Route;

public abstract class TypedRoute<T, R>
implements Route {
    public abstract R onRequest(T var1, Request var2, Response var3);

    public Object handle(Request request, Response response) {
        try {
            Class typeOfT = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Object requestObject = TypifyProvider.gson().fromJson(request.body(), typeOfT);
            Method method = this.getClass().getMethod("onRequest", Object.class, Request.class, Response.class);
            Json json = method.getAnnotation(Json.class);
            Xml xml = method.getAnnotation(Xml.class);
            R result = this.onRequest(requestObject, request, response);
            if (json != null) {
                response.type(ContentType.APPLICATION_JSON.getValue());
                return TypifyProvider.gson().toJson(result);
            }
            if (xml != null) {
                response.type(ContentType.APPLICATION_XML.getValue());
                throw new UnsupportedOperationException("XML mapping not supported yet");
            }
            response.type(ContentType.APPLICATION_JSON.getValue());
            return TypifyProvider.gson().toJson(result);
        }
        catch (NoSuchMethodException | SecurityException e) {
            ReflectionExceptions.handleReflectionException(e);
            return null;
        }
    }
}

